/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin;

import com.djrapitops.plugin.APFPlugin;
import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.PluginCommon;
import com.djrapitops.plugin.api.utility.Version;
import com.djrapitops.plugin.benchmarking.Timings;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.bukkit.BukkitCommand;
import com.djrapitops.plugin.logging.console.JavaUtilPluginLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.logging.debug.CombineDebugLogger;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import com.djrapitops.plugin.logging.debug.MemoryDebugLogger;
import com.djrapitops.plugin.logging.error.DefaultErrorHandler;
import com.djrapitops.plugin.logging.error.ErrorHandler;
import com.djrapitops.plugin.task.RunnableFactory;
import com.djrapitops.plugin.task.bukkit.BukkitRunnableFactory;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BukkitPlugin
extends JavaPlugin
implements APFPlugin {
    protected final CombineDebugLogger debugLogger;
    protected final DefaultErrorHandler errorHandler;
    protected final Timings timings;
    protected final RunnableFactory runnableFactory;
    protected PluginLogger logger;
    protected boolean reloading;

    public BukkitPlugin() {
        this(new CombineDebugLogger(new MemoryDebugLogger()));
    }

    public BukkitPlugin(CombineDebugLogger debugLogger) {
        this.debugLogger = debugLogger;
        this.runnableFactory = new BukkitRunnableFactory(this);
        this.timings = new Timings(debugLogger);
        this.logger = new JavaUtilPluginLogger(message -> this.getServer().getConsoleSender().sendMessage(message), this::getDebugLogger, () -> ((BukkitPlugin)this).getLogger());
        this.errorHandler = new DefaultErrorHandler((IPlugin)this, this.logger, new File(this.getDataFolder(), "logs"));
    }

    @Override
    public void onDisable() {
        this.runnableFactory.cancelAllKnownTasks();
    }

    public void registerListener(Listener ... listeners) {
        for (Listener listener : listeners) {
            if (listener == null) {
                this.logger.warn("Attempted to register a null listener!");
                continue;
            }
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    @Override
    public void registerCommand(String name, CommandNode command) {
        if (command == null) {
            this.logger.warn("Attempted to register a null command for name '" + name + "'!");
            return;
        }
        this.getCommand(name).setExecutor((CommandExecutor)new BukkitCommand(command));
    }

    protected boolean isNewVersionAvailable(String versionStringUrl) throws IOException {
        return Version.checkVersion(this.getVersion(), versionStringUrl);
    }

    @Override
    public void reloadPlugin(boolean full) {
        PluginCommon.reload(this, full);
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }

    @Override
    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }

    @Override
    public RunnableFactory getRunnableFactory() {
        return this.runnableFactory;
    }

    @Override
    public PluginLogger getPluginLogger() {
        return this.logger;
    }

    @Override
    public DebugLogger getDebugLogger() {
        return this.debugLogger;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public Timings getTimings() {
        return this.timings;
    }

    @Override
    public void setDebugLoggers(DebugLogger ... loggers) {
        this.debugLogger.setDebugLoggers(loggers);
    }

    @Override
    public void setErrorHandlers(ErrorHandler ... errorHandlers) {
        this.errorHandler.setErrorHandlers(errorHandlers);
    }

    @Override
    public void onReload() {
    }
}

