/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin;

import com.djrapitops.plugin.APFPlugin;
import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.PluginCommon;
import com.djrapitops.plugin.api.utility.Version;
import com.djrapitops.plugin.benchmarking.Timings;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.bungee.BungeeCommand;
import com.djrapitops.plugin.logging.console.JavaUtilPluginLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.logging.debug.CombineDebugLogger;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import com.djrapitops.plugin.logging.debug.MemoryDebugLogger;
import com.djrapitops.plugin.logging.error.DefaultErrorHandler;
import com.djrapitops.plugin.logging.error.ErrorHandler;
import com.djrapitops.plugin.task.RunnableFactory;
import com.djrapitops.plugin.task.bungee.BungeeRunnableFactory;
import java.io.File;
import java.io.IOException;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;

public abstract class BungeePlugin
extends Plugin
implements APFPlugin {
    protected final CombineDebugLogger debugLogger;
    protected final DefaultErrorHandler errorHandler;
    protected final Timings timings;
    protected final RunnableFactory runnableFactory;
    protected PluginLogger logger;
    protected boolean reloading;

    public BungeePlugin() {
        this(new CombineDebugLogger(new MemoryDebugLogger()));
    }

    public BungeePlugin(CombineDebugLogger debugLogger) {
        this.debugLogger = debugLogger;
        this.runnableFactory = new BungeeRunnableFactory(this);
        this.timings = new Timings(debugLogger);
        this.logger = new JavaUtilPluginLogger(message -> this.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent(message)), this::getDebugLogger, () -> ((BungeePlugin)this).getLogger());
        this.errorHandler = new DefaultErrorHandler((IPlugin)this, this.logger, () -> new File(this.getDataFolder(), "logs"));
    }

    @Override
    public void onDisable() {
        this.runnableFactory.cancelAllKnownTasks();
    }

    @Override
    public void reloadPlugin(boolean full) {
        PluginCommon.reload(this, full);
    }

    public void registerListener(Listener ... listeners) {
        for (Listener listener : listeners) {
            if (listener == null) {
                this.logger.warn("Attempted to register a null listener!");
                continue;
            }
            this.getProxy().getPluginManager().registerListener((Plugin)this, listener);
        }
    }

    @Override
    public void registerCommand(String name, CommandNode command) {
        if (command == null) {
            this.logger.warn("Attempted to register a null command for name '" + name + "'!");
            return;
        }
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BungeeCommand(name, command));
    }

    protected boolean isNewVersionAvailable(String versionStringUrl) throws IOException {
        return Version.checkVersion(this.getVersion(), versionStringUrl);
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }

    @Override
    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }

    @Override
    public RunnableFactory getRunnableFactory() {
        return this.runnableFactory;
    }

    @Override
    public PluginLogger getPluginLogger() {
        return this.logger;
    }

    @Override
    public DebugLogger getDebugLogger() {
        return this.debugLogger;
    }

    @Override
    public void setDebugLoggers(DebugLogger ... loggers) {
        this.debugLogger.setDebugLoggers(loggers);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandlers(ErrorHandler ... errorHandlers) {
        this.errorHandler.setErrorHandlers(errorHandlers);
    }

    @Override
    public Timings getTimings() {
        return this.timings;
    }

    @Override
    public void onReload() {
    }
}

