/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin;

import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import com.djrapitops.plugin.APFPlugin;
import com.djrapitops.plugin.PluginCommon;
import com.djrapitops.plugin.api.utility.Version;
import com.djrapitops.plugin.benchmarking.Timings;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.nukkit.NukkitCMDSender;
import com.djrapitops.plugin.logging.console.NukkitPluginLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.logging.debug.CombineDebugLogger;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import com.djrapitops.plugin.logging.debug.MemoryDebugLogger;
import com.djrapitops.plugin.logging.error.ErrorHandler;
import com.djrapitops.plugin.task.RunnableFactory;
import com.djrapitops.plugin.task.nukkit.NukkitRunnableFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NukkitPlugin
extends PluginBase
implements APFPlugin {
    protected final CombineDebugLogger debugLogger;
    protected final Timings timings;
    protected final RunnableFactory runnableFactory;
    private final Map<String, CommandNode> commands;
    protected PluginLogger logger;
    protected boolean reloading;

    public NukkitPlugin() {
        this(new CombineDebugLogger(new MemoryDebugLogger()));
    }

    public NukkitPlugin(CombineDebugLogger debugLogger) {
        this.debugLogger = debugLogger;
        this.runnableFactory = new NukkitRunnableFactory(this);
        this.timings = new Timings(debugLogger);
        this.logger = new NukkitPluginLogger(message -> this.getServer().getConsoleSender().sendMessage(message), this::getDebugLogger, () -> ((NukkitPlugin)this).getLogger());
        this.commands = new HashMap<String, CommandNode>();
    }

    @Override
    public void onDisable() {
        this.runnableFactory.cancelAllKnownTasks();
    }

    public void registerListener(Listener ... listeners) {
        for (Listener listener : listeners) {
            if (listener == null) {
                this.logger.warn("Attempted to register a null listener!");
                continue;
            }
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    @Override
    public void registerCommand(String name, CommandNode command) {
        if (command == null) {
            this.logger.warn("Attempted to register a null command for name '" + name + "'!");
            return;
        }
        this.commands.put(name, command);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CommandNode found = this.commands.get(command.getName());
        if (found == null) {
            return false;
        }
        found.onCommand(new NukkitCMDSender(sender), label, args);
        return true;
    }

    protected boolean isNewVersionAvailable(String versionStringUrl) throws IOException {
        return Version.checkVersion(this.getVersion(), versionStringUrl);
    }

    @Override
    public void reloadPlugin(boolean full) {
        PluginCommon.reload(this, full);
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }

    @Override
    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }

    @Override
    public RunnableFactory getRunnableFactory() {
        return this.runnableFactory;
    }

    @Override
    public PluginLogger getPluginLogger() {
        return this.logger;
    }

    @Override
    public DebugLogger getDebugLogger() {
        return this.debugLogger;
    }

    @Override
    @Deprecated
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public Timings getTimings() {
        return this.timings;
    }

    @Override
    public void setDebugLoggers(DebugLogger ... loggers) {
        this.debugLogger.setDebugLoggers(loggers);
    }

    @Override
    public void setErrorHandlers(ErrorHandler ... errorHandlers) {
    }

    @Override
    public void onReload() {
    }

    @Override
    public String getVersion() {
        return super.getDescription().getVersion();
    }
}

