/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin;

import com.djrapitops.plugin.APFPlugin;
import com.djrapitops.plugin.IPlugin;
import com.djrapitops.plugin.PluginCommon;
import com.djrapitops.plugin.benchmarking.Timings;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.sponge.SpongeCommand;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.logging.console.Slf4jPluginLogger;
import com.djrapitops.plugin.logging.debug.CombineDebugLogger;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import com.djrapitops.plugin.logging.debug.MemoryDebugLogger;
import com.djrapitops.plugin.logging.error.DefaultErrorHandler;
import com.djrapitops.plugin.logging.error.ErrorHandler;
import com.djrapitops.plugin.task.RunnableFactory;
import com.djrapitops.plugin.task.sponge.SpongeRunnableFactory;
import com.djrapitops.plugin.utilities.Verify;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.plugin.Plugin;

public abstract class SpongePlugin
implements APFPlugin {
    protected final PluginLogger logger;
    protected final CombineDebugLogger debugLogger;
    protected final DefaultErrorHandler errorHandler;
    protected final Timings timings;
    protected final RunnableFactory runnableFactory;
    private final Map<String, CommandMapping> commandMappings = new HashMap<String, CommandMapping>();
    protected boolean reloading;

    public SpongePlugin() {
        this(new CombineDebugLogger(new MemoryDebugLogger()));
    }

    public SpongePlugin(CombineDebugLogger debugLogger) {
        this.debugLogger = debugLogger;
        this.runnableFactory = new SpongeRunnableFactory(this);
        this.timings = new Timings(debugLogger);
        this.logger = new Slf4jPluginLogger(this::getLogger, this::getDebugLogger);
        this.errorHandler = new DefaultErrorHandler((IPlugin)this, this.logger, new File(this.getDataFolder(), "logs"));
    }

    public abstract Logger getLogger();

    @Override
    public String getVersion() {
        Plugin annotation = this.getClass().getAnnotation(Plugin.class);
        return Verify.nullCheck(annotation, () -> new IllegalStateException(this.getClass().getName() + " does not have required @Plugin annotation.")).version();
    }

    @Override
    public void onDisable() {
        this.runnableFactory.cancelAllKnownTasks();
    }

    @Override
    public void reloadPlugin(boolean full) {
        PluginCommon.reload(this, full);
    }

    @Override
    public void registerCommand(String name, CommandNode command) {
        if (command == null) {
            this.logger.warn("Attempted to register a null command for name '" + name + "'!");
            return;
        }
        CommandManager commandManager = Sponge.getCommandManager();
        CommandMapping registered = this.commandMappings.get(name);
        if (registered != null) {
            commandManager.removeMapping(registered);
        }
        Optional register = commandManager.register((Object)this, (CommandCallable)new SpongeCommand(command), new String[]{name});
        register.ifPresent(commandMapping -> this.commandMappings.put(name, (CommandMapping)commandMapping));
    }

    public void registerListener(Object ... listeners) {
        for (Object listener : listeners) {
            if (listener == null) {
                this.logger.warn("Attempted to register a null listener!");
                continue;
            }
            Sponge.getEventManager().registerListeners((Object)this, listener);
        }
    }

    @Listener
    public void reload(GameReloadEvent event) {
        this.reloadPlugin(true);
    }

    @Override
    public RunnableFactory getRunnableFactory() {
        return this.runnableFactory;
    }

    @Override
    public PluginLogger getPluginLogger() {
        return this.logger;
    }

    @Override
    public DebugLogger getDebugLogger() {
        return this.debugLogger;
    }

    @Override
    public void setDebugLoggers(DebugLogger ... loggers) {
        this.debugLogger.setDebugLoggers(loggers);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandlers(ErrorHandler ... errorHandlers) {
        this.errorHandler.setErrorHandlers(errorHandlers);
    }

    @Override
    public Timings getTimings() {
        return this.timings;
    }

    @Override
    public void onReload() {
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }

    @Override
    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }
}

