/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api;

import java.util.concurrent.TimeUnit;

public enum TimeAmount {
    WEEK(TimeUnit.DAYS.toMillis(7L)),
    MONTH(TimeUnit.DAYS.toMillis(30L)),
    YEAR(TimeUnit.DAYS.toMillis(365L));

    private final long ms;

    private TimeAmount(long ms) {
        this.ms = ms;
    }

    public static long toTicks(long amount, TimeUnit unit) {
        return unit.toMillis(amount) / 50L;
    }

    public static long ticksToMillis(long ticks) {
        return ticks * 50L;
    }

    public long toMillis(long amount) {
        return this.ms * amount;
    }
}

