/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.api.utility;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;

public class Version
implements Comparable<Version> {
    private final String versionString;

    public Version(String versionString) {
        this.versionString = versionString;
    }

    public static Version getGitVersion(String url) throws IOException {
        URL githubUrl = new URL(url);
        String lineWithVersion = "";
        try (Scanner websiteScanner = new Scanner(githubUrl.openStream());){
            while (websiteScanner.hasNextLine()) {
                String line = websiteScanner.nextLine();
                if (!line.toLowerCase().contains("version")) continue;
                lineWithVersion = line;
                break;
            }
        }
        return new Version(lineWithVersion.split(": ")[1]);
    }

    public static boolean isNewVersionAvailable(Version currentVersion, Version newVersion) {
        return newVersion.compareTo(currentVersion) > 0;
    }

    public static boolean checkVersion(String version, String versionStringUrl) throws IOException {
        Version currentVersion = new Version(version);
        boolean gitHub = versionStringUrl.contains("raw.githubusercontent.com");
        try {
            if (gitHub) {
                return Version.isNewVersionAvailable(currentVersion, Version.getGitVersion(versionStringUrl));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Version fetch error, address: " + versionStringUrl, e);
        }
        throw new IOException("Version can not be fetched from this address: " + versionStringUrl);
    }

    @Override
    public int compareTo(Version o) {
        return Long.compare(this.getVersionLong(), o.getVersionLong());
    }

    public long getVersionLong() {
        String replaced = this.versionString.replaceAll("[^0-9]", ".");
        String[] split = replaced.split("\\.");
        List version = Arrays.stream(split).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        long versionNumber = 0L;
        for (int i = 0; i < version.size(); ++i) {
            int num = Integer.parseInt((String)version.get(i));
            long multiplier = (long)Math.pow(100.0, 8.0 - (double)i);
            versionNumber += (long)num * multiplier;
        }
        return versionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return Objects.equals(this.versionString, version.versionString);
    }

    public int hashCode() {
        return Objects.hash(this.versionString);
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String toString() {
        return this.versionString;
    }
}

