/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.benchmarking;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Benchmark
implements Comparable<Benchmark> {
    private final long ns;
    private final long estimatedMemoryUse;
    private String name;

    Benchmark(long ns, long estimatedMemoryUse) {
        this.ns = ns;
        this.estimatedMemoryUse = estimatedMemoryUse;
    }

    Benchmark(String name, long ns, long estimatedMemoryUse) {
        this.name = name;
        this.ns = ns;
        this.estimatedMemoryUse = estimatedMemoryUse;
    }

    public String getName() {
        return this.name;
    }

    public long getNs() {
        return this.ns;
    }

    @Override
    public int compareTo(Benchmark o) {
        return this.name.toLowerCase().compareTo(o.name.toLowerCase());
    }

    public String toDurationString() {
        long millisecondNs = TimeUnit.MILLISECONDS.toNanos(1L);
        if (this.ns < millisecondNs) {
            return this.ns + " ns";
        }
        return this.ns / millisecondNs + " ms";
    }

    public String toMemoryString() {
        long usedKilobytes = this.estimatedMemoryUse / 1000L;
        if (this.estimatedMemoryUse == 0L) {
            return " 0 B";
        }
        if (this.estimatedMemoryUse > 0L) {
            if (this.estimatedMemoryUse < 1000L) {
                return "+" + this.estimatedMemoryUse + " B";
            }
            if (usedKilobytes > 1000L) {
                return "+" + usedKilobytes / 1000L + " MB";
            }
            return "+" + usedKilobytes + " KB";
        }
        if (this.estimatedMemoryUse > -1000L) {
            return this.estimatedMemoryUse + " B";
        }
        if (usedKilobytes < -1000L) {
            return usedKilobytes / 1000L + " MB";
        }
        return usedKilobytes + " KB";
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.toDurationString());
        while (b.length() < 11) {
            b.append(" ");
        }
        b.append(this.toMemoryString());
        while (b.length() < 19) {
            b.append(" ");
        }
        b.append(this.name);
        return b.toString();
    }

    public long getUsedMemory() {
        return this.estimatedMemoryUse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Benchmark)) {
            return false;
        }
        Benchmark benchmark = (Benchmark)o;
        return this.ns == benchmark.ns && this.estimatedMemoryUse == benchmark.estimatedMemoryUse && Objects.equals(this.name, benchmark.name);
    }

    public int hashCode() {
        return Objects.hash(this.ns, this.estimatedMemoryUse, this.name);
    }
}

