/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.benchmarking;

import com.djrapitops.plugin.benchmarking.Benchmark;
import com.djrapitops.plugin.benchmarking.RunningBenchmark;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Timings {
    private final Map<String, Benchmark> rollingAverage;
    private final Map<String, Long> timesRun;
    private final Map<String, RunningBenchmark> running;
    private final DebugLogger debugLogger;

    public Timings(DebugLogger debugLogger) {
        this.debugLogger = debugLogger;
        this.rollingAverage = new HashMap<String, Benchmark>();
        this.timesRun = new HashMap<String, Long>();
        this.running = new HashMap<String, RunningBenchmark>();
    }

    public void start(String name) {
        this.running.put(name, new RunningBenchmark(name));
    }

    public Optional<Benchmark> end(String name) {
        RunningBenchmark bench = this.running.get(name);
        if (bench == null) {
            return Optional.empty();
        }
        Benchmark result = bench.end();
        Long times = this.timesRun.getOrDefault(name, 0L);
        Benchmark currentAverage = this.rollingAverage.get(name);
        long weighedAvgNs = currentAverage != null ? (result.getNs() + currentAverage.getNs() * times) / (times + 1L) : result.getNs();
        long weighedAvgMem = currentAverage != null ? (result.getUsedMemory() + currentAverage.getUsedMemory() * times) / (times + 1L) : result.getUsedMemory();
        this.rollingAverage.put(name, new Benchmark(name, weighedAvgNs, weighedAvgMem));
        this.timesRun.put(name, times + 1L);
        return Optional.of(result);
    }

    public Optional<Benchmark> end(String debugChannel, String name) {
        Optional<Benchmark> benchmark = this.end(name);
        benchmark.ifPresent(bench -> this.debugLogger.logOn(debugChannel, bench.toString()));
        return benchmark;
    }

    public void reset() {
        this.running.clear();
        this.rollingAverage.clear();
    }

    public List<Benchmark> getAverageResults() {
        ArrayList<Benchmark> averageResults = new ArrayList<Benchmark>(this.rollingAverage.values());
        Collections.sort(averageResults);
        return averageResults;
    }
}

