/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command;

import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;

public abstract class CommandNode {
    private final String aliases;
    private final CommandType commandType;
    private String permission;
    private String[] arguments = new String[0];
    private String onHover;
    private String shortHelp = "";
    private String[] inDepthHelp;

    public CommandNode(String aliases, String permission, CommandType commandType) {
        this.aliases = aliases;
        this.permission = permission;
        this.commandType = commandType;
    }

    @Deprecated
    public CommandNode(String name, CommandType type, String permission, String usage, String arguments) {
        this(name, permission, type);
        this.shortHelp = usage;
        this.arguments = arguments.split(" ");
    }

    @Deprecated
    public CommandNode(String name, CommandType type) {
        this(name, "", type);
    }

    @Deprecated
    public CommandNode(String name, CommandType type, String permission) {
        this(name, permission, type);
    }

    @Deprecated
    public CommandNode(String name, CommandType type, String permission, String shortHelp) {
        this(name, permission, type);
        this.setShortHelp(shortHelp);
    }

    public abstract void onCommand(Sender var1, String var2, String[] var3);

    public String getName() {
        return this.getAliases()[0];
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public String[] getAliases() {
        return this.aliases.split("\\|");
    }

    public String[] getArguments() {
        return this.arguments;
    }

    protected CommandNode setArguments(String ... arguments) {
        this.arguments = arguments;
        return this;
    }

    public String getOnHover() {
        return this.onHover;
    }

    protected CommandNode setOnHover(String onHover) {
        this.onHover = onHover;
        return this;
    }

    public String getShortHelp() {
        return this.shortHelp;
    }

    protected CommandNode setShortHelp(String help) {
        this.shortHelp = help;
        return this;
    }

    public String[] getInDepthHelp() {
        if (this.inDepthHelp != null) {
            return this.inDepthHelp;
        }
        return new String[]{this.shortHelp};
    }

    protected CommandNode setInDepthHelp(String ... inDepthHelp) {
        if (inDepthHelp == null || inDepthHelp.length == 0) {
            return this;
        }
        this.inDepthHelp = inDepthHelp;
        return this;
    }
}

