/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command;

import com.djrapitops.plugin.command.ColorScheme;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.command.defaultcmds.HelpCommand;
import com.djrapitops.plugin.utilities.ArrayUtil;
import com.djrapitops.plugin.utilities.Verify;
import java.util.Arrays;

public class TreeCmdNode
extends CommandNode {
    private final HelpCommand helpCommand;
    private final CommandNode parent;
    private ColorScheme colorScheme;
    private String defaultCommand = "help";
    private CommandNode[][] nodeGroups = new CommandNode[0][];

    public TreeCmdNode(String name, String permission, CommandType commandType, CommandNode parent) {
        super(name, permission, commandType);
        this.helpCommand = new HelpCommand(this);
        this.parent = parent;
    }

    public String getCommandString() {
        StringBuilder builder = new StringBuilder();
        builder.insert(0, this.getName());
        CommandNode cmdNode = this.parent;
        while (cmdNode != null) {
            builder.insert(0, cmdNode.getName() + " ");
            if (cmdNode instanceof TreeCmdNode) {
                cmdNode = ((TreeCmdNode)cmdNode).parent;
                continue;
            }
            cmdNode = null;
        }
        return builder.insert(0, "/").toString();
    }

    public CommandNode[][] getNodeGroups() {
        return this.nodeGroups;
    }

    public void setNodeGroups(CommandNode[] ... nodeGroups) {
        Verify.nullCheck(nodeGroups);
        this.nodeGroups = nodeGroups;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme != null ? this.colorScheme : new ColorScheme("\u00a7f", "\u00a7f", "\u00a7f");
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public void setDefaultCommand(String defaultCommand) {
        Verify.nullCheck(defaultCommand);
        this.defaultCommand = defaultCommand;
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        try {
            if (args.length == 0) {
                this.helpCommand.onCommand(sender, commandLabel, args);
                return;
            }
            CommandNode command = this.getCommand(args);
            CommandType cmdType = command.getCommandType();
            boolean console = !CommandUtils.isPlayer(sender);
            this.consoleTypeCheck(cmdType, console);
            this.checkPermission(sender, this);
            this.checkPermission(sender, command);
            boolean isDefaultCommandWithoutCommandArg = this.checkArguments(args, command, console, cmdType);
            if (args[args.length - 1].equals("?")) {
                this.sendInDepthHelp(sender, args, command);
                return;
            }
            String[] realArgs = args;
            if (!isDefaultCommandWithoutCommandArg) {
                realArgs = ArrayUtil.removeFirstArgument(args);
            }
            command.onCommand(sender, commandLabel, realArgs);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cNumber Required: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("\u00a7cBad Argument: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            sender.sendMessage("\u00a7c" + e.getMessage());
        }
    }

    private void sendInDepthHelp(Sender sender, String[] args, CommandNode command) {
        if (args.length == 1) {
            sender.sendMessage(this.getInDepthHelp());
            sender.sendMessage("Aliases: " + Arrays.toString(this.getAliases()));
        } else {
            sender.sendMessage(command.getInDepthHelp());
            sender.sendMessage("Aliases: " + Arrays.toString(command.getAliases()));
        }
    }

    private void consoleTypeCheck(CommandType cmdType, boolean console) throws IllegalAccessException {
        if (console && cmdType == CommandType.PLAYER) {
            throw new IllegalAccessException("Command can only be used as a player.");
        }
    }

    private void checkPermission(Sender sender, CommandNode command) throws IllegalAccessException {
        String permission = command.getPermission();
        if (!Verify.isEmpty(permission) && !sender.hasPermission(permission)) {
            throw new IllegalAccessException("You do not have the required permission.");
        }
    }

    private boolean checkArguments(String[] args, CommandNode command, boolean console, CommandType cmdType) throws IllegalAccessException {
        boolean isDefaultCommandWithoutCommandArg;
        String commandName = command.getName();
        boolean bl = isDefaultCommandWithoutCommandArg = commandName.equals(this.defaultCommand) && args.length <= 1 && !args[0].equals(commandName);
        if (!isDefaultCommandWithoutCommandArg && (cmdType == CommandType.ALL_WITH_ARGS && args.length < 2 || console && args.length < 2 && cmdType == CommandType.PLAYER_OR_ARGS)) {
            throw new IllegalAccessException("Too few arguments! " + Arrays.toString(this.getArguments()));
        }
        return isDefaultCommandWithoutCommandArg;
    }

    private CommandNode getCommand(String[] args) {
        if (args.length < 1) {
            return this.helpCommand;
        }
        String name = args[0];
        CommandNode cmd = this.getMatchingCommand(name);
        if (cmd != null) {
            return cmd;
        }
        if (!this.defaultCommand.equals(args[0])) {
            return this.getCommand(ArrayUtil.merge({this.defaultCommand}, args));
        }
        return this.helpCommand;
    }

    private CommandNode getMatchingCommand(String name) {
        CommandNode[][] commandNodeArray = this.nodeGroups;
        int n = commandNodeArray.length;
        for (int i = 0; i < n; ++i) {
            CommandNode[] nodeGroup;
            for (CommandNode node : nodeGroup = commandNodeArray[i]) {
                String[] aliases;
                if (node == null) continue;
                for (String alias : aliases = node.getAliases()) {
                    if (!alias.trim().equalsIgnoreCase(name)) continue;
                    return node;
                }
            }
        }
        return null;
    }

    public HelpCommand getHelpCommand() {
        return this.helpCommand;
    }
}

