/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command.bukkit;

import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.command.SenderType;
import com.djrapitops.plugin.command.bukkit.LinkSender;
import org.bukkit.ChatColor;
import org.bukkit.block.CommandBlock;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class BukkitCMDSender
implements Sender {
    private final CommandSender cs;

    BukkitCMDSender(CommandSender cs) {
        this.cs = cs;
    }

    @Override
    public void sendMessage(String string) {
        if (!(this.cs instanceof Player)) {
            this.cs.sendMessage(string);
            return;
        }
        int length = string.length();
        if (length > 60) {
            int i;
            for (i = 59; i < length && string.charAt(i) != ' '; ++i) {
            }
            String shortened = string.substring(0, i);
            String lastCols = ChatColor.getLastColors((String)string);
            this.cs.sendMessage(shortened);
            String leftover = lastCols + string.substring(i);
            this.sendMessage(leftover);
        } else {
            if (ChatColor.stripColor((String)string).isEmpty()) {
                return;
            }
            this.cs.sendMessage(string);
        }
    }

    @Override
    public void sendMessage(String[] strings) {
        this.cs.sendMessage(strings);
    }

    @Override
    public void sendLink(String pretext, String linkText, String url) {
        try {
            if (CommandUtils.isPlayer(this)) {
                LinkSender.send(this.cs, pretext, linkText, url);
                return;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.cs.sendMessage(url);
    }

    @Override
    public void sendLink(String linkText, String url) {
        this.sendLink("", linkText, url);
    }

    @Override
    public String getName() {
        return this.cs.getName();
    }

    @Override
    public boolean hasPermission(String string) {
        return this.cs.hasPermission(string);
    }

    @Override
    public boolean isOp() {
        return this.cs.isOp();
    }

    @Override
    public SenderType getSenderType() {
        if (this.cs instanceof Player) {
            return SenderType.PLAYER;
        }
        if (this.cs instanceof CommandBlock) {
            return SenderType.CMD_BLOCK;
        }
        return SenderType.CONSOLE;
    }

    public CommandSender getSender() {
        return this.cs;
    }
}

