/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command.bungee;

import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.command.SenderType;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ConnectedPlayer;
import net.md_5.bungee.api.connection.ProxiedPlayer;

class BungeeCMDSender
implements Sender {
    private final CommandSender cs;

    BungeeCMDSender(CommandSender cs) {
        this.cs = cs;
    }

    @Override
    public String getName() {
        return this.cs.getName();
    }

    @Override
    public void sendMessage(String string) {
        ComponentBuilder c = new ComponentBuilder(string);
        this.cs.sendMessage(c.create());
    }

    @Override
    public void sendLink(String pretext, String linkText, String url) {
        TextComponent message = new TextComponent(pretext);
        TextComponent link = new TextComponent(linkText);
        link.setUnderlined(Boolean.valueOf(true));
        message.addExtra((BaseComponent)link);
        message.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        this.cs.sendMessage((BaseComponent)message);
    }

    @Override
    public void sendLink(String linkText, String url) {
        this.sendLink("", linkText, url);
    }

    @Override
    public boolean hasPermission(String string) {
        return this.cs.hasPermission(string);
    }

    @Override
    public void sendMessage(String[] strings) {
        for (int i = 1; i < strings.length; ++i) {
            this.sendMessage(strings[i]);
        }
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public SenderType getSenderType() {
        if (this.cs instanceof ConnectedPlayer) {
            return SenderType.PLAYER;
        }
        if (this.cs instanceof ProxiedPlayer) {
            return SenderType.PROXY_PLAYER;
        }
        return SenderType.CONSOLE;
    }

    public CommandSender getSender() {
        return this.cs;
    }
}

