/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command.defaultcmds;

import com.djrapitops.plugin.command.ColorScheme;
import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.CommandType;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.command.TreeCmdNode;
import com.djrapitops.plugin.utilities.Verify;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HelpCommand
extends CommandNode {
    private final TreeCmdNode treeCmdNode;

    public HelpCommand(TreeCmdNode treeCmdNode) {
        super("help|?", "", CommandType.ALL);
        this.treeCmdNode = treeCmdNode;
    }

    @Override
    public void onCommand(Sender sender, String commandLabel, String[] args) {
        this.getHelpMessages(sender).forEach(sender::sendMessage);
    }

    public List<String> getHelpMessages(Sender sender) {
        String helpPermission = this.getPermission();
        if (!Verify.isEmpty(helpPermission) && !sender.hasPermission(helpPermission)) {
            return Collections.singletonList("\u00a7cYou do not have the required permission.");
        }
        ColorScheme colorScheme = this.treeCmdNode.getColorScheme();
        String cMain = colorScheme.getMainColor();
        String cSec = colorScheme.getSecondaryColor();
        String cTer = colorScheme.getTertiaryColor();
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(cTer + "> SubCommands " + cMain + this.treeCmdNode.getCommandString());
        messages.add("  ");
        for (CommandNode[] commandNodes : this.treeCmdNode.getNodeGroups()) {
            boolean addedCmdInfos = false;
            for (CommandNode node : commandNodes) {
                String permission;
                if (node == null || !Verify.isEmpty(permission = node.getPermission()) && !sender.hasPermission(permission)) continue;
                messages.add(cMain + "  " + this.getNameAndArgs(node) + " " + cTer + node.getShortHelp());
                addedCmdInfos = true;
            }
            if (!addedCmdInfos) continue;
            messages.add("  ");
        }
        messages.add("  " + cSec + "Add ? to the end of the command for more help");
        messages.add(cTer + ">");
        return messages;
    }

    private String getNameAndArgs(CommandNode node) {
        StringBuilder builder = new StringBuilder(node.getName());
        for (String arg : node.getArguments()) {
            builder.append(" ").append(arg);
        }
        return builder.toString();
    }
}

