/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command.nukkit;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.lang.TextContainer;
import cn.nukkit.permission.Permission;
import cn.nukkit.permission.PermissionAttachment;
import cn.nukkit.permission.PermissionAttachmentInfo;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.utils.TextFormat;
import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.command.SenderType;
import java.util.Map;

public class NukkitCMDSender
implements Sender {
    private final CommandSender cs;

    public NukkitCMDSender(CommandSender cs) {
        this.cs = cs;
    }

    @Override
    public void sendMessage(String[] strings) {
        for (String string : strings) {
            this.sendMessage(string);
        }
    }

    @Override
    public void sendLink(String pretext, String linkText, String url) {
        this.cs.sendMessage(pretext + url);
    }

    @Override
    public SenderType getSenderType() {
        if (this.cs.isPlayer()) {
            return SenderType.PLAYER;
        }
        return SenderType.CONSOLE;
    }

    @Override
    public Object getSender() {
        return this.cs;
    }

    @Override
    public void sendMessage(String message) {
        if (!(this.cs instanceof Player)) {
            this.cs.sendMessage(message);
            return;
        }
        int length = message.length();
        if (length > 60) {
            int i;
            for (i = 59; i < length && message.charAt(i) != ' '; ++i) {
            }
            String shortened = message.substring(0, i);
            String lastCols = TextFormat.getLastColors((String)message);
            this.cs.sendMessage(shortened);
            String leftover = lastCols + message.substring(i);
            this.sendMessage(leftover);
        } else {
            if (TextFormat.clean((String)message).isEmpty()) {
                return;
            }
            this.cs.sendMessage(message);
        }
    }

    public void sendMessage(TextContainer message) {
        this.cs.sendMessage(message);
    }

    public Server getServer() {
        return this.cs.getServer();
    }

    @Override
    public String getName() {
        return this.cs.getName();
    }

    public boolean isPlayer() {
        return this.cs.isPlayer();
    }

    public boolean isPermissionSet(String name) {
        return this.cs.isPermissionSet(name);
    }

    public boolean isPermissionSet(Permission permission) {
        return this.cs.isPermissionSet(permission);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.cs.hasPermission(name);
    }

    public boolean hasPermission(Permission permission) {
        return this.cs.hasPermission(permission);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.cs.addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name) {
        return this.cs.addAttachment(plugin, name);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, Boolean value) {
        return this.cs.addAttachment(plugin, name, value);
    }

    public void removeAttachment(PermissionAttachment attachment) {
        this.cs.removeAttachment(attachment);
    }

    public void recalculatePermissions() {
        this.cs.recalculatePermissions();
    }

    public Map<String, PermissionAttachmentInfo> getEffectivePermissions() {
        return this.cs.getEffectivePermissions();
    }

    @Override
    public boolean isOp() {
        return this.cs.isOp();
    }

    public void setOp(boolean value) {
        this.cs.setOp(value);
    }
}

