/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command.sponge;

import com.djrapitops.plugin.command.Sender;
import com.djrapitops.plugin.command.SenderType;
import java.net.MalformedURLException;
import java.net.URL;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.CommandBlockSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.source.RconSource;
import org.spongepowered.api.command.source.SignSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;

class SpongeCMDSender
implements Sender {
    private final CommandSource commandSource;

    SpongeCMDSender(CommandSource commandSource) {
        this.commandSource = commandSource;
    }

    @Override
    public void sendMessage(String string) {
        this.commandSource.sendMessage((Text)Text.of((String)string));
    }

    @Override
    public void sendMessage(String[] strings) {
        for (String string : strings) {
            this.sendMessage(string);
        }
    }

    @Override
    public void sendLink(String pretext, String linkText, String url) {
        try {
            this.commandSource.sendMessage(Text.join((Text[])new Text[]{Text.of((String)pretext), Text.builder((String)linkText).style(new TextStyle[]{TextStyles.UNDERLINE}).onClick((ClickAction)TextActions.openUrl((URL)new URL(url))).build()}));
        }
        catch (MalformedURLException e) {
            this.sendLink(linkText, url, url);
        }
    }

    @Override
    public void sendLink(String linkText, String url) {
        try {
            this.commandSource.sendMessage((Text)Text.builder((String)linkText).onClick((ClickAction)TextActions.openUrl((URL)new URL(url))).build());
        }
        catch (MalformedURLException e) {
            this.sendLink(linkText, url, url);
        }
    }

    @Override
    public String getName() {
        return this.commandSource.getName();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.commandSource.hasPermission(permission);
    }

    @Override
    public boolean isOp() {
        return false;
    }

    @Override
    public SenderType getSenderType() {
        if (this.commandSource instanceof CommandBlockSource || this.commandSource instanceof SignSource) {
            return SenderType.CMD_BLOCK;
        }
        if (this.commandSource instanceof ConsoleSource) {
            return SenderType.CONSOLE;
        }
        if (this.commandSource instanceof Player) {
            return SenderType.PLAYER;
        }
        if (this.commandSource instanceof RconSource) {
            return SenderType.PROXY_PLAYER;
        }
        return SenderType.CONSOLE;
    }

    public CommandSource getSender() {
        return this.commandSource;
    }
}

