/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.command.sponge;

import com.djrapitops.plugin.command.CommandNode;
import com.djrapitops.plugin.command.sponge.SpongeCMDSender;
import com.djrapitops.plugin.utilities.Verify;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SpongeCommand
implements CommandCallable {
    private final CommandNode command;

    public SpongeCommand(CommandNode command) {
        this.command = command;
    }

    public CommandResult process(CommandSource source, String arguments) {
        if (arguments.isEmpty()) {
            this.command.onCommand(new SpongeCMDSender(source), "", new String[0]);
        } else {
            String[] args = arguments.split(" ");
            this.command.onCommand(new SpongeCMDSender(source), "", args);
        }
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, @Nullable Location<World> targetPosition) {
        return new ArrayList<String>();
    }

    public boolean testPermission(CommandSource source) {
        String permission = this.command.getPermission();
        return Verify.isEmpty(permission) || source.hasPermission(permission);
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        String shortHelp = this.command.getShortHelp();
        if (shortHelp != null) {
            return Optional.of(Text.of((String)shortHelp));
        }
        return Optional.empty();
    }

    public Optional<Text> getHelp(CommandSource source) {
        Object[] inDepthHelp = this.command.getInDepthHelp();
        if (inDepthHelp != null) {
            String helpString = Arrays.toString(inDepthHelp);
            return Optional.of(Text.of((String)helpString.substring(1, helpString.length() - 1)));
        }
        return Optional.empty();
    }

    public Text getUsage(CommandSource source) {
        String usageString = Arrays.toString(this.command.getArguments());
        return Text.of((String)usageString.substring(1, usageString.length() - 1));
    }
}

