/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.config;

import com.djrapitops.plugin.config.ConfigNode;
import com.djrapitops.plugin.logging.FileLogger;
import com.djrapitops.plugin.utilities.Verify;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Deprecated
public class Config
extends ConfigNode {
    private static final String APF_NEWLINE = " APF_NEWLINE ";
    private String absolutePath;

    public Config(File file) {
        super("", null, "");
        File folder = file.getParentFile();
        this.absolutePath = file.getAbsolutePath();
        try {
            Verify.isTrue(folder.exists() || folder.mkdirs(), () -> new FileNotFoundException("Folders could not be created for config file " + this.absolutePath));
            Verify.isTrue(file.exists() || file.createNewFile(), () -> new FileNotFoundException("Could not create file: " + this.absolutePath));
            this.read();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Config(File file, List<String> defaults) {
        this(file);
        this.copyDefaults(defaults);
    }

    private Config(List<String> defaults) {
        super("", null, "");
        this.absolutePath = null;
        this.processLines(defaults, true);
    }

    private File getFile() {
        return this.absolutePath != null ? new File(this.absolutePath) : null;
    }

    public void read() throws IOException {
        File file = this.getFile();
        Verify.isTrue(file != null, () -> new FileNotFoundException("File was null"));
        Verify.isTrue(file.exists() || file.createNewFile(), () -> new FileNotFoundException("Could not create file: " + this.absolutePath));
        this.childOrder.clear();
        this.getChildren().clear();
        this.processLines(this.readLines(file.toPath()), true);
    }

    public void copyDefaults(File from) throws IOException {
        this.copyDefaults(this.readLines(from.toPath()));
    }

    private List<String> readLines(Path from) throws IOException {
        try (Stream<String> s = Files.lines(from, Charset.forName("UTF-8"));){
            List<String> list = s.collect(Collectors.toList());
            return list;
        }
    }

    public void copyDefaults(List<String> lines) {
        this.copyDefaults(new Config(lines));
    }

    private void processLines(List<String> fileLines, boolean override) {
        ArrayList<String> comments = new ArrayList<String>();
        int lastDepth = 0;
        ConfigNode parent = this;
        ConfigNode lastNode = this;
        for (String line : fileLines) {
            try {
                String valueWithoutComment;
                int depth = FileLogger.getIndentation(line);
                String trimmed = line.trim();
                if (trimmed.startsWith("#")) {
                    comments.add(trimmed);
                    continue;
                }
                String[] keyAndValue = trimmed.split(":", 2);
                if (keyAndValue.length <= 1) {
                    boolean wasListItem;
                    String lastValue = lastNode.getValue();
                    boolean isListItem = trimmed.startsWith("-");
                    boolean bl = wasListItem = lastValue.contains(APF_NEWLINE.trim()) || lastValue.trim().isEmpty();
                    if (isListItem && wasListItem) {
                        lastNode.set(lastValue + APF_NEWLINE + trimmed);
                        continue;
                    }
                    if (lastValue.startsWith("\"") && trimmed.endsWith("\"") || lastValue.startsWith("'") && trimmed.endsWith("'")) {
                        lastNode.set(lastValue.substring(1) + " " + trimmed.substring(0, trimmed.length() - 1));
                        continue;
                    }
                    lastNode.set(lastValue + " " + trimmed);
                    continue;
                }
                String configKey = keyAndValue[0];
                if (depth > lastDepth) {
                    parent = lastNode;
                } else if (depth < lastDepth) {
                    int nDepth = lastDepth;
                    while (nDepth > depth) {
                        nDepth = parent.depth;
                        parent = parent.parent;
                    }
                }
                String value = keyAndValue[1].trim();
                int indexOfHashTag = value.lastIndexOf(" #");
                String string = valueWithoutComment = indexOfHashTag < 0 ? value : value.substring(0, indexOfHashTag);
                if (indexOfHashTag > 0) {
                    String comment = value.substring(indexOfHashTag + 1);
                    comments.add(comment);
                }
                ConfigNode node = parent.getChildren().get(configKey);
                if (override || node == null) {
                    node = new ConfigNode(configKey, parent, valueWithoutComment);
                }
                node.depth = depth;
                node.setComment(new ArrayList<String>(comments));
                comments.clear();
                lastNode = node;
                lastDepth = depth;
                parent.addChild(configKey, node);
            }
            catch (Exception e) {
                throw new IllegalStateException("Malformed File (" + this.absolutePath + "), Error on line " + fileLines.indexOf(line) + ": " + line, e);
            }
        }
    }

    @Override
    public void save() throws IOException {
        File file = this.getFile();
        Verify.nullCheck(file, () -> new IllegalStateException("Absolute Path was null (Not defined)"));
        Files.write(file.toPath(), this.processTree(), Charset.forName("UTF-8"), new OpenOption[0]);
    }

    private List<String> processTree() {
        return this.getLines(this, 0);
    }

    private List<String> getLines(ConfigNode root, int depth) {
        ArrayList<String> lines = new ArrayList<String>();
        Map<String, ConfigNode> children = root.getChildren();
        for (String key : root.childOrder) {
            ConfigNode node = children.get(key);
            String value = node.getValue();
            for (String commentLine : node.getComment()) {
                StringBuilder comment = new StringBuilder();
                this.addIndentation(depth, comment);
                comment.append(commentLine);
                lines.add(comment.toString());
            }
            StringBuilder b = new StringBuilder();
            this.addIndentation(depth, b);
            if (value.startsWith(APF_NEWLINE)) {
                String[] list;
                lines.add(b.append(key).append(":").toString());
                for (String listValue : list = value.split(APF_NEWLINE)) {
                    String v = listValue.trim();
                    if (v.isEmpty()) continue;
                    StringBuilder listBuilder = new StringBuilder();
                    this.addIndentation(depth + 1, listBuilder);
                    listBuilder.append(v);
                    lines.add(listBuilder.toString());
                }
            } else {
                if (value.isEmpty()) {
                    b.append(key).append(":");
                } else {
                    b.append(key).append(": ").append(value);
                }
                lines.add(b.toString());
            }
            lines.addAll(this.getLines(node, depth + 1));
        }
        return lines;
    }

    private void addIndentation(int depth, StringBuilder b) {
        for (int i = 0; i < depth; ++i) {
            b.append("    ");
        }
    }
}

