/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.logging;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileLogger {
    private FileLogger() {
    }

    public static void appendToFile(File file, String ... lines) throws IOException {
        FileLogger.appendToFile(file, Arrays.asList(lines));
    }

    public static void logToFile(File file, List<String> lines) throws IOException {
        Files.write(file.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void appendToFile(File file, List<String> lines) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            return;
        }
        try {
            Files.write(file.toPath(), lines, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            // empty catch block
        }
    }

    public static List<String> readContents(File file) throws IOException {
        try (Stream<String> lines = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
            List<String> list = lines.collect(Collectors.toList());
            return list;
        }
    }

    public static int getIndentation(String line) {
        int indentation = 0;
        for (char c : line.toCharArray()) {
            if (c != ' ') break;
            ++indentation;
        }
        return indentation;
    }
}

