/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.logging;

import com.djrapitops.plugin.logging.FileLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.error.ErrorHandler;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FolderTimeStampFileLogger {
    private final String fileNamePrefix;
    private final Supplier<File> logFolder;
    private final Supplier<ErrorHandler> errorHandler;

    public FolderTimeStampFileLogger(String fileNamePrefix, File logFolder, Supplier<ErrorHandler> errorHandler) {
        this(fileNamePrefix, () -> logFolder, errorHandler);
    }

    public FolderTimeStampFileLogger(String fileNamePrefix, Supplier<File> logFolder, Supplier<ErrorHandler> errorHandler) {
        this.fileNamePrefix = fileNamePrefix;
        this.logFolder = logFolder;
        this.errorHandler = errorHandler;
    }

    public void log(String ... lines) {
        File logFile = new File(this.logFolder.get(), this.getFileName());
        try {
            FileLogger.appendToFile(logFile, Arrays.stream(lines).map(line -> "| " + this.getTimeStamp() + " | " + line).collect(Collectors.toList()));
        }
        catch (IOException e) {
            this.errorHandler.get().log(L.CRITICAL, this.getClass(), e);
        }
    }

    public String getTimeStamp() {
        return new SimpleDateFormat("MM-dd HH:mm:ss").format(System.currentTimeMillis());
    }

    private String getFileName() {
        String day = new SimpleDateFormat("yyyy_MM_dd").format(System.currentTimeMillis());
        return this.fileNamePrefix + "-" + day + ".txt";
    }

    public Optional<File> getCurrentFile() {
        File file = new File(this.logFolder.get(), this.getFileName());
        if (file.exists()) {
            return Optional.of(file);
        }
        return Optional.empty();
    }
}

