/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.logging.console;

import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtilPluginLogger
implements PluginLogger {
    protected final Consumer<String> console;
    protected final Supplier<DebugLogger> debugLogger;
    protected final Supplier<Logger> logger;

    public JavaUtilPluginLogger(Consumer<String> console, Supplier<DebugLogger> debugLogger, Logger logger) {
        this(console, debugLogger, () -> logger);
    }

    public JavaUtilPluginLogger(Consumer<String> console, Supplier<DebugLogger> debugLogger, Supplier<Logger> logger) {
        this.console = console;
        this.debugLogger = debugLogger;
        this.logger = logger;
    }

    @Override
    public void log(L level, String ... message) {
        if (level == L.DEBUG) {
            this.debugLogger.get().log(message);
            return;
        }
        if (level != L.DEBUG_INFO) {
            this.log(L.DEBUG, message);
        }
        switch (level) {
            case CRITICAL: 
            case ERROR: {
                for (String line : message) {
                    this.logger.get().log(Level.SEVERE, line);
                }
                break;
            }
            case WARN: {
                for (String line : message) {
                    this.logger.get().log(Level.WARNING, line);
                }
                break;
            }
            case INFO_COLOR: {
                for (String line : message) {
                    this.console.accept(line);
                }
                break;
            }
            case DEBUG_INFO: {
                for (String line : message) {
                    this.logger.get().log(Level.INFO, "[DEBUG] {0}", line);
                }
                break;
            }
            default: {
                for (String line : message) {
                    this.logger.get().log(Level.INFO, line);
                }
            }
        }
    }

    @Override
    public void log(L level, String message, Throwable throwable) {
        switch (level) {
            case CRITICAL: 
            case ERROR: {
                this.logger.get().log(Level.SEVERE, message, throwable);
                break;
            }
            default: {
                this.logger.get().log(Level.WARNING, message, throwable);
            }
        }
    }

    @Override
    public DebugLogger getDebugLogger() {
        return this.debugLogger.get();
    }
}

