/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.logging.console;

import cn.nukkit.utils.LogLevel;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class NukkitPluginLogger
implements PluginLogger {
    protected final Consumer<String> console;
    protected final Supplier<DebugLogger> debugLogger;
    protected final Supplier<cn.nukkit.plugin.PluginLogger> logger;

    public NukkitPluginLogger(Consumer<String> console, Supplier<DebugLogger> debugLogger, cn.nukkit.plugin.PluginLogger logger) {
        this(console, debugLogger, () -> logger);
    }

    public NukkitPluginLogger(Consumer<String> console, Supplier<DebugLogger> debugLogger, Supplier<cn.nukkit.plugin.PluginLogger> logger) {
        this.console = console;
        this.debugLogger = debugLogger;
        this.logger = logger;
    }

    @Override
    public void log(L level, String ... message) {
        if (level == L.DEBUG) {
            this.debugLogger.get().log(message);
            return;
        }
        if (level != L.DEBUG_INFO) {
            this.log(L.DEBUG, message);
        }
        switch (level) {
            case CRITICAL: 
            case ERROR: {
                for (String line : message) {
                    this.logger.get().log(LogLevel.ERROR, line);
                }
                break;
            }
            case WARN: {
                for (String line : message) {
                    this.logger.get().log(LogLevel.WARNING, line);
                }
                break;
            }
            case INFO_COLOR: {
                for (String line : message) {
                    this.console.accept(line);
                }
                break;
            }
            case DEBUG_INFO: {
                for (String line : message) {
                    this.logger.get().log(LogLevel.INFO, "[DEBUG] " + line);
                }
                break;
            }
            default: {
                for (String line : message) {
                    this.logger.get().log(LogLevel.INFO, line);
                }
            }
        }
    }

    @Override
    public void log(L level, String message, Throwable throwable) {
        switch (level) {
            case CRITICAL: 
            case ERROR: {
                this.logger.get().log(LogLevel.ERROR, message, throwable);
                break;
            }
            default: {
                this.logger.get().log(LogLevel.WARNING, message, throwable);
            }
        }
    }

    @Override
    public DebugLogger getDebugLogger() {
        return this.debugLogger.get();
    }
}

