/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.logging.debug;

import com.djrapitops.plugin.logging.debug.DebugLogger;
import java.util.Optional;

public class CombineDebugLogger
implements DebugLogger {
    private DebugLogger[] loggers;

    public CombineDebugLogger(DebugLogger ... loggers) {
        this.loggers = loggers;
    }

    @Override
    public void logOn(String channel, String ... lines) {
        for (DebugLogger logger : this.loggers) {
            logger.logOn(channel, lines);
        }
    }

    public void setDebugLoggers(DebugLogger ... loggers) {
        this.loggers = loggers;
    }

    public <T extends DebugLogger> Optional<T> getDebugLogger(Class<T> ofType) {
        for (DebugLogger logger : this.loggers) {
            if (!ofType.isAssignableFrom(logger.getClass())) continue;
            return Optional.of(ofType.cast(logger));
        }
        return Optional.empty();
    }
}

