/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.logging.debug;

import com.djrapitops.plugin.logging.debug.DebugLogger;
import com.djrapitops.plugin.utilities.EjectingQueue;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MemoryDebugLogger
implements DebugLogger {
    private final Map<String, EjectingQueue<String>> channels = new HashMap<String, EjectingQueue<String>>();

    @Override
    public void logOn(String channel, String ... lines) {
        String timeStamp = this.getTimeStamp();
        EjectingQueue<String> messages = this.channels.getOrDefault(channel, new EjectingQueue(100));
        for (String line : lines) {
            messages.add(timeStamp + " | " + line);
        }
        this.channels.put(channel, messages);
    }

    public String getTimeStamp() {
        return new SimpleDateFormat("MM-dd HH:mm:ss").format(System.currentTimeMillis());
    }

    public Map<String, List<String>> getChannels() {
        return this.channels.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((EjectingQueue)e.getValue()).getElements()));
    }
}

