/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.logging.error;

import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.error.ErrorHandler;
import java.util.Optional;

public class CombineErrorHandler
implements ErrorHandler {
    private ErrorHandler[] handlers;

    public CombineErrorHandler(ErrorHandler ... handlers) {
        this.handlers = handlers;
    }

    @Override
    public void log(L level, Class caughtBy, Throwable throwable) {
        for (ErrorHandler handler : this.handlers) {
            handler.log(level, caughtBy, throwable);
        }
    }

    public void setErrorHandlers(ErrorHandler ... handlers) {
        this.handlers = handlers;
    }

    public <T extends ErrorHandler> Optional<T> getErrorHandler(Class<T> ofType) {
        for (ErrorHandler handler : this.handlers) {
            if (!ofType.isAssignableFrom(handler.getClass())) continue;
            return Optional.of(ofType.cast(handler));
        }
        return Optional.empty();
    }
}

