/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.logging.error;

import com.djrapitops.plugin.logging.FolderTimeStampFileLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.error.ErrorHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;

public class FolderTimeStampErrorFileLogger
extends FolderTimeStampFileLogger
implements ErrorHandler {
    public FolderTimeStampErrorFileLogger(File logFolder, ErrorHandler errorHandler) {
        super("Errors", logFolder, () -> errorHandler);
    }

    public FolderTimeStampErrorFileLogger(Supplier<File> logFolder, ErrorHandler errorHandler) {
        super("Errors", logFolder, () -> errorHandler);
    }

    public static SortedMap<String, List<String>> splitByError(List<String> lines) {
        if (lines.isEmpty()) {
            return new TreeMap<String, List<String>>();
        }
        String splittingLine = " caught ";
        TreeMap<String, List<String>> errors = new TreeMap<String, List<String>>();
        ArrayList<String> errorLines = null;
        String currentError = null;
        for (String line : lines) {
            if (line.contains(splittingLine)) {
                if (errorLines != null) {
                    errors.put(currentError, (List<String>)errorLines);
                }
                currentError = line;
                errorLines = new ArrayList<String>();
                continue;
            }
            if (errorLines == null) continue;
            errorLines.add(line);
        }
        return errors;
    }

    @Override
    public void log(L level, Class caughtBy, Throwable throwable) {
        this.log(caughtBy.getName() + " caught " + throwable.getClass().getSimpleName());
        List<String> stackTrace = this.getStackTrace(throwable);
        for (String line : stackTrace) {
            this.log(line);
        }
    }

    private List<String> getStackTrace(Throwable e) {
        ArrayList<String> trace = new ArrayList<String>();
        trace.add(e.toString());
        for (StackTraceElement element : e.getStackTrace()) {
            trace.add("   " + element);
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            trace.add("Caused by:");
            trace.addAll(this.getStackTrace(cause));
        }
        return trace;
    }
}

