/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task.bukkit;

import com.djrapitops.plugin.BukkitPlugin;
import com.djrapitops.plugin.task.PluginRunnable;
import com.djrapitops.plugin.task.PluginTask;
import com.djrapitops.plugin.task.bukkit.AbsBukkitTask;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AbsBukkitRunnable
extends BukkitRunnable
implements PluginRunnable,
Runnable {
    private final String name;
    private final long time;
    private int id = -1;
    private BukkitPlugin plugin;

    AbsBukkitRunnable(String name, BukkitPlugin plugin, long time) {
        this.name = name;
        this.time = time;
        this.plugin = plugin;
    }

    @Override
    public PluginTask runTask() {
        AbsBukkitTask task = new AbsBukkitTask(super.runTask((Plugin)this.plugin));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskAsynchronously() {
        AbsBukkitTask task = new AbsBukkitTask(super.runTaskAsynchronously((Plugin)this.plugin));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskLater(long delay) {
        AbsBukkitTask task = new AbsBukkitTask(super.runTaskLater((Plugin)this.plugin, delay));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskLaterAsynchronously(long delay) {
        AbsBukkitTask task = new AbsBukkitTask(super.runTaskLaterAsynchronously((Plugin)this.plugin, delay));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskTimer(long delay, long period) {
        AbsBukkitTask task = new AbsBukkitTask(super.runTaskTimer((Plugin)this.plugin, delay, period));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskTimerAsynchronously(long delay, long period) {
        AbsBukkitTask task = new AbsBukkitTask(super.runTaskTimerAsynchronously((Plugin)this.plugin, delay, period));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public synchronized void cancel() {
        if (this.plugin == null) {
            return;
        }
        try {
            this.plugin.getServer().getScheduler().cancelTask(this.id);
            super.cancel();
        }
        finally {
            this.plugin = null;
        }
    }

    @Override
    public String getTaskName() {
        return this.name;
    }

    @Override
    public long getTime() {
        return this.time;
    }
}

