/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task.bungee;

import com.djrapitops.plugin.BungeePlugin;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.task.PluginRunnable;
import com.djrapitops.plugin.task.PluginTask;
import com.djrapitops.plugin.task.bungee.AbsBungeeTask;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.TaskScheduler;

public abstract class AbsBungeeRunnable
implements PluginRunnable,
Runnable {
    private final String name;
    private final long time;
    private BungeePlugin plugin;
    private TaskScheduler scheduler;
    private int id = -1;

    AbsBungeeRunnable(String name, BungeePlugin plugin, long time) {
        this.name = name;
        this.time = time;
        this.plugin = plugin;
        this.scheduler = plugin.getProxy().getScheduler();
    }

    @Override
    public PluginTask runTask() {
        return this.runTaskAsynchronously();
    }

    @Override
    public PluginTask runTaskAsynchronously() {
        AbsBungeeTask task = new AbsBungeeTask(this.scheduler.runAsync((Plugin)this.plugin, (Runnable)this));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskLater(long delay) {
        return this.runTaskLaterAsynchronously(delay);
    }

    @Override
    public PluginTask runTaskLaterAsynchronously(long delay) {
        AbsBungeeTask task = new AbsBungeeTask(this.scheduler.schedule((Plugin)this.plugin, (Runnable)this, TimeAmount.ticksToMillis(delay), TimeUnit.MILLISECONDS));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskTimer(long delay, long period) {
        return this.runTaskTimerAsynchronously(delay, period);
    }

    @Override
    public PluginTask runTaskTimerAsynchronously(long delay, long period) {
        AbsBungeeTask task = new AbsBungeeTask(this.scheduler.schedule((Plugin)this.plugin, (Runnable)this, TimeAmount.ticksToMillis(delay), TimeAmount.ticksToMillis(period), TimeUnit.MILLISECONDS));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public synchronized void cancel() {
        if (this.plugin == null) {
            return;
        }
        try {
            this.scheduler.cancel(this.id);
        }
        finally {
            this.plugin = null;
            this.scheduler = null;
        }
    }

    @Override
    public int getTaskId() {
        return this.id;
    }

    @Override
    public String getTaskName() {
        return this.name;
    }

    @Override
    public long getTime() {
        return this.time;
    }
}

