/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task.nukkit;

import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.ServerScheduler;
import com.djrapitops.plugin.NukkitPlugin;
import com.djrapitops.plugin.task.PluginRunnable;
import com.djrapitops.plugin.task.PluginTask;
import com.djrapitops.plugin.task.nukkit.AbsNukkitTask;

public abstract class AbsNukkitRunnable
implements PluginRunnable,
Runnable {
    private final String name;
    private final ServerScheduler scheduler;
    private final long time;
    private int id = -1;
    private NukkitPlugin plugin;

    AbsNukkitRunnable(String name, NukkitPlugin plugin, ServerScheduler scheduler, long time) {
        this.name = name;
        this.scheduler = scheduler;
        this.time = time;
        this.plugin = plugin;
    }

    @Override
    public PluginTask runTask() {
        AbsNukkitTask task = new AbsNukkitTask(this.scheduler.scheduleTask((Plugin)this.plugin, (Runnable)this));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskAsynchronously() {
        AbsNukkitTask task = new AbsNukkitTask(this.scheduler.scheduleTask((Plugin)this.plugin, (Runnable)this, true));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskLater(long delay) {
        AbsNukkitTask task = new AbsNukkitTask(this.scheduler.scheduleDelayedTask((Plugin)this.plugin, (Runnable)this, (int)delay));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskLaterAsynchronously(long delay) {
        AbsNukkitTask task = new AbsNukkitTask(this.scheduler.scheduleDelayedTask((Plugin)this.plugin, (Runnable)this, (int)delay, true));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskTimer(long delay, long period) {
        AbsNukkitTask task = new AbsNukkitTask(this.scheduler.scheduleDelayedRepeatingTask((Plugin)this.plugin, (Runnable)this, (int)delay, (int)period));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public PluginTask runTaskTimerAsynchronously(long delay, long period) {
        AbsNukkitTask task = new AbsNukkitTask(this.scheduler.scheduleDelayedRepeatingTask((Plugin)this.plugin, (Runnable)this, (int)delay, (int)period, true));
        this.id = task.getTaskId();
        return task;
    }

    @Override
    public synchronized void cancel() {
        if (this.plugin == null || this.id == -1) {
            return;
        }
        try {
            this.plugin.getServer().getScheduler().cancelTask(this.id);
        }
        finally {
            this.plugin = null;
        }
    }

    @Override
    public int getTaskId() {
        return this.id;
    }

    @Override
    public String getTaskName() {
        return this.name;
    }

    @Override
    public long getTime() {
        return this.time;
    }
}

