/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task.sponge;

import com.djrapitops.plugin.SpongePlugin;
import com.djrapitops.plugin.task.PluginRunnable;
import com.djrapitops.plugin.task.PluginTask;
import com.djrapitops.plugin.task.sponge.AbsSpongeTask;
import org.spongepowered.api.scheduler.Task;

abstract class AbsSpongeRunnable
implements PluginRunnable,
Runnable {
    private final String name;
    private final long time;
    private SpongePlugin plugin;
    private PluginTask task;

    AbsSpongeRunnable(String name, SpongePlugin plugin, long time) {
        this.time = time;
        this.plugin = plugin;
        this.name = name;
    }

    @Override
    public String getTaskName() {
        return this.name;
    }

    @Override
    public void cancel() {
        if (this.plugin == null) {
            return;
        }
        try {
            if (this.task != null) {
                this.task.cancel();
            }
        }
        finally {
            this.plugin = null;
        }
    }

    @Override
    public int getTaskId() {
        return -1;
    }

    @Override
    public PluginTask runTask() {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).submit((Object)this.plugin));
        return this.task;
    }

    @Override
    public PluginTask runTaskAsynchronously() {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).async().submit((Object)this.plugin));
        return this.task;
    }

    @Override
    public PluginTask runTaskLater(long delay) {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).delayTicks(delay).submit((Object)this.plugin));
        return this.task;
    }

    @Override
    public PluginTask runTaskLaterAsynchronously(long delay) {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).async().delayTicks(delay).submit((Object)this.plugin));
        return this.task;
    }

    @Override
    public PluginTask runTaskTimer(long delay, long period) {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).delayTicks(delay).intervalTicks(period).submit((Object)this.plugin));
        return this.task;
    }

    @Override
    public PluginTask runTaskTimerAsynchronously(long delay, long period) {
        this.task = new AbsSpongeTask(Task.builder().execute((Runnable)this).async().delayTicks(delay).intervalTicks(period).submit((Object)this.plugin));
        return this.task;
    }

    @Override
    public long getTime() {
        return this.time;
    }
}

