/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.task.velocity;

import com.djrapitops.plugin.VelocityPlugin;
import com.djrapitops.plugin.task.AbsRunnable;
import com.djrapitops.plugin.task.PluginRunnable;
import com.djrapitops.plugin.task.RunnableFactory;
import com.djrapitops.plugin.task.velocity.AbsVelocityRunnable;
import com.velocitypowered.api.scheduler.Scheduler;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class VelocityRunnableFactory
extends RunnableFactory {
    private final VelocityPlugin plugin;
    private final Scheduler scheduler;
    private Set<AbsVelocityRunnable> tasks;

    public VelocityRunnableFactory(VelocityPlugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.tasks = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    protected PluginRunnable createNewRunnable(String name, final AbsRunnable runnable, long time) {
        this.cleanUp();
        AbsVelocityRunnable taskRunnable = new AbsVelocityRunnable(name, this.plugin, this.scheduler, time){

            @Override
            public void run() {
                VelocityRunnableFactory.this.setCancellable(runnable, this);
                runnable.run();
            }
        };
        this.tasks.add(taskRunnable);
        return taskRunnable;
    }

    private synchronized void cleanUp() {
        this.tasks.removeIf(runnable -> runnable.getTask().isFinished());
    }

    @Override
    public synchronized void cancelAllKnownTasks() {
        this.tasks.forEach(PluginRunnable::cancel);
        this.tasks.clear();
    }
}

