/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.utilities;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;

public class EjectingQueue<E> {
    private final int maxSize;
    private ArrayDeque<E> queue;
    private volatile int size;

    public EjectingQueue(int maxSize) {
        this.maxSize = maxSize;
        this.queue = new ArrayDeque(maxSize);
        this.size = 0;
    }

    public synchronized void add(E element) {
        if (this.size >= this.maxSize) {
            this.queue.poll();
            --this.size;
        }
        this.queue.add(element);
        ++this.size;
    }

    public void clear() {
        this.queue.clear();
        this.size = 0;
    }

    public ImmutableList<E> getElements() {
        return ImmutableList.copyOf(this.queue);
    }
}

