/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.utilities;

import java.util.Objects;

public class Format {
    private String string;

    public Format(String string) {
        this.string = string;
    }

    @Deprecated
    public static Format create(String string) {
        return new Format(string);
    }

    public Format removeLetters() {
        this.string = this.string.replaceAll("[A-Za-z]", "");
        return this;
    }

    public Format removeSymbols() {
        this.string = this.string.replaceAll("[^a-zA-Z0-9_\\s]", "");
        return this;
    }

    public Format removeSymbolsButDot() {
        this.string = this.string.replaceAll("[^a-zA-Z0-9_\\s\\.]", "");
        return this;
    }

    public Format removeDot() {
        this.string = this.string.replaceAll("\\.", "");
        return this;
    }

    public Format removeNumbers() {
        this.string = this.string.replaceAll("[0-9]", "");
        return this;
    }

    public Format removeWhitespace() {
        this.string = this.string.replaceAll("[\\s]", "");
        return this;
    }

    public Format spaceWhitespace() {
        this.string = this.string.replaceAll("[\\s]", " ");
        return this;
    }

    public Format remove(String ... regex) {
        Format removed = this;
        for (String reg : regex) {
            removed = this.remove(reg);
        }
        return removed;
    }

    public Format remove(String regex) {
        this.string = this.string.replaceAll(regex, "");
        return this;
    }

    public Format remove(char ... characters) {
        Format removed = this;
        for (char character : characters) {
            removed = this.remove(character);
        }
        return removed;
    }

    public Format remove(char character) {
        this.string = this.string.replace(String.valueOf(character), "");
        return this;
    }

    public Format justNumbers() {
        return this.removeLetters().removeSymbols().removeWhitespace();
    }

    public Format justLetters() {
        return this.removeNumbers().removeSymbols().removeWhitespace();
    }

    public Format justSymbols() {
        return this.removeNumbers().removeLetters().removeWhitespace();
    }

    public Format upperCase() {
        this.string = this.string.toUpperCase();
        return this;
    }

    public Format lowerCase() {
        this.string = this.string.toLowerCase();
        return this;
    }

    public Format capitalize() {
        this.string = (this.string.charAt(0) + "").toUpperCase() + this.string.substring(1).toLowerCase();
        return this;
    }

    public Format removeFirstAndLastChar() {
        this.string = this.string.substring(1, this.string.length() - 1);
        return this;
    }

    public String toString() {
        return this.string;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.string);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Format other = (Format)obj;
        return Objects.equals(this.string, other.string);
    }
}

