/*
 * Decompiled with CFR 0.152.
 */
package plan.com.google.htmlcompressor;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.JSSourceFile;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import plan.com.google.htmlcompressor.analyzer.HtmlAnalyzer;
import plan.com.google.htmlcompressor.compressor.ClosureJavaScriptCompressor;
import plan.com.google.htmlcompressor.compressor.Compressor;
import plan.com.google.htmlcompressor.compressor.HtmlCompressor;
import plan.com.google.htmlcompressor.compressor.XmlCompressor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineCompressor {
    private static final Pattern urlPattern = Pattern.compile("^https?://.*$", 2);
    private boolean helpOpt;
    private boolean analyzeOpt;
    private String charsetOpt;
    private String outputFilenameOpt;
    private String patternsFilenameOpt;
    private String typeOpt;
    private String filemaskOpt;
    private boolean recursiveOpt;
    private boolean preserveCommentsOpt;
    private boolean preserveIntertagSpacesOpt;
    private boolean preserveMultiSpacesOpt;
    private boolean removeIntertagSpacesOpt;
    private boolean removeQuotesOpt;
    private String removeSurroundingSpacesOpt;
    private boolean preserveLineBreaksOpt;
    private boolean preservePhpTagsOpt;
    private boolean preserveServerScriptTagsOpt;
    private boolean preserveSsiTagsOpt;
    private boolean compressJsOpt;
    private boolean compressCssOpt;
    private String jsCompressorOpt;
    private boolean simpleDoctypeOpt;
    private boolean removeScriptAttributesOpt;
    private boolean removeStyleAttributesOpt;
    private boolean removeLinkAttributesOpt;
    private boolean removeFormAttributesOpt;
    private boolean removeInputAttributesOpt;
    private boolean simpleBooleanAttributesOpt;
    private boolean removeJavaScriptProtocolOpt;
    private boolean removeHttpProtocolOpt;
    private boolean removeHttpsProtocolOpt;
    private boolean nomungeOpt;
    private int linebreakOpt;
    private boolean preserveSemiOpt;
    private boolean disableOptimizationsOpt;
    private String closureOptLevelOpt;
    private boolean closureCustomExternsOnlyOpt;
    private List<String> closureExternsOpt;
    private String[] fileArgsOpt;

    public static void main(String[] args) {
        CmdLineCompressor cmdLineCompressor = new CmdLineCompressor(args);
        cmdLineCompressor.process(args);
    }

    public CmdLineCompressor(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option helpOptAlt = parser.addBooleanOption('?', "help_alt");
        CmdLineParser.Option analyzeOpt = parser.addBooleanOption('a', "analyze");
        CmdLineParser.Option recursiveOpt = parser.addBooleanOption('r', "recursive");
        CmdLineParser.Option charsetOpt = parser.addStringOption('c', "charset");
        CmdLineParser.Option outputFilenameOpt = parser.addStringOption('o', "output");
        CmdLineParser.Option patternsFilenameOpt = parser.addStringOption('p', "preserve");
        CmdLineParser.Option typeOpt = parser.addStringOption('t', "type");
        CmdLineParser.Option filemaskOpt = parser.addStringOption('m', "mask");
        CmdLineParser.Option preserveCommentsOpt = parser.addBooleanOption("preserve-comments");
        CmdLineParser.Option preserveIntertagSpacesOpt = parser.addBooleanOption("preserve-intertag-spaces");
        CmdLineParser.Option preserveMultiSpacesOpt = parser.addBooleanOption("preserve-multi-spaces");
        CmdLineParser.Option removeIntertagSpacesOpt = parser.addBooleanOption("remove-intertag-spaces");
        CmdLineParser.Option removeSurroundingSpacesOpt = parser.addStringOption("remove-surrounding-spaces");
        CmdLineParser.Option removeQuotesOpt = parser.addBooleanOption("remove-quotes");
        CmdLineParser.Option preserveLineBreaksOpt = parser.addBooleanOption("preserve-line-breaks");
        CmdLineParser.Option preservePhpTagsOpt = parser.addBooleanOption("preserve-php");
        CmdLineParser.Option preserveServerScriptTagsOpt = parser.addBooleanOption("preserve-server-script");
        CmdLineParser.Option preserveSsiTagsOpt = parser.addBooleanOption("preserve-ssi");
        CmdLineParser.Option compressJsOpt = parser.addBooleanOption("compress-js");
        CmdLineParser.Option compressCssOpt = parser.addBooleanOption("compress-css");
        CmdLineParser.Option jsCompressorOpt = parser.addStringOption("js-compressor");
        CmdLineParser.Option simpleDoctypeOpt = parser.addBooleanOption("simple-doctype");
        CmdLineParser.Option removeScriptAttributesOpt = parser.addBooleanOption("remove-script-attr");
        CmdLineParser.Option removeStyleAttributesOpt = parser.addBooleanOption("remove-style-attr");
        CmdLineParser.Option removeLinkAttributesOpt = parser.addBooleanOption("remove-link-attr");
        CmdLineParser.Option removeFormAttributesOpt = parser.addBooleanOption("remove-form-attr");
        CmdLineParser.Option removeInputAttributesOpt = parser.addBooleanOption("remove-input-attr");
        CmdLineParser.Option simpleBooleanAttributesOpt = parser.addBooleanOption("simple-bool-attr");
        CmdLineParser.Option removeJavaScriptProtocolOpt = parser.addBooleanOption("remove-js-protocol");
        CmdLineParser.Option removeHttpProtocolOpt = parser.addBooleanOption("remove-http-protocol");
        CmdLineParser.Option removeHttpsProtocolOpt = parser.addBooleanOption("remove-https-protocol");
        CmdLineParser.Option nomungeOpt = parser.addBooleanOption("nomunge");
        CmdLineParser.Option linebreakOpt = parser.addStringOption("line-break");
        CmdLineParser.Option preserveSemiOpt = parser.addBooleanOption("preserve-semi");
        CmdLineParser.Option disableOptimizationsOpt = parser.addBooleanOption("disable-optimizations");
        CmdLineParser.Option closureOptLevelOpt = parser.addStringOption("closure-opt-level");
        CmdLineParser.Option closureCustomExternsOnlyOpt = parser.addBooleanOption("closure-custom-externs-only");
        CmdLineParser.Option closureExternsOpt = parser.addStringOption("closure-externs");
        try {
            parser.parse(args);
            this.helpOpt = (Boolean)parser.getOptionValue(helpOpt, (Object)false) != false || (Boolean)parser.getOptionValue(helpOptAlt, (Object)false) != false;
            this.analyzeOpt = (Boolean)parser.getOptionValue(analyzeOpt, (Object)false);
            this.recursiveOpt = (Boolean)parser.getOptionValue(recursiveOpt, (Object)false);
            this.charsetOpt = (String)parser.getOptionValue(charsetOpt, (Object)"UTF-8");
            this.outputFilenameOpt = (String)parser.getOptionValue(outputFilenameOpt);
            this.patternsFilenameOpt = (String)parser.getOptionValue(patternsFilenameOpt);
            this.typeOpt = (String)parser.getOptionValue(typeOpt);
            this.filemaskOpt = (String)parser.getOptionValue(filemaskOpt);
            this.preserveCommentsOpt = (Boolean)parser.getOptionValue(preserveCommentsOpt, (Object)false);
            this.preserveIntertagSpacesOpt = (Boolean)parser.getOptionValue(preserveIntertagSpacesOpt, (Object)false);
            this.preserveMultiSpacesOpt = (Boolean)parser.getOptionValue(preserveMultiSpacesOpt, (Object)false);
            this.removeIntertagSpacesOpt = (Boolean)parser.getOptionValue(removeIntertagSpacesOpt, (Object)false);
            this.removeQuotesOpt = (Boolean)parser.getOptionValue(removeQuotesOpt, (Object)false);
            this.preserveLineBreaksOpt = (Boolean)parser.getOptionValue(preserveLineBreaksOpt, (Object)false);
            this.preservePhpTagsOpt = (Boolean)parser.getOptionValue(preservePhpTagsOpt, (Object)false);
            this.preserveServerScriptTagsOpt = (Boolean)parser.getOptionValue(preserveServerScriptTagsOpt, (Object)false);
            this.preserveSsiTagsOpt = (Boolean)parser.getOptionValue(preserveSsiTagsOpt, (Object)false);
            this.compressJsOpt = (Boolean)parser.getOptionValue(compressJsOpt, (Object)false);
            this.compressCssOpt = (Boolean)parser.getOptionValue(compressCssOpt, (Object)false);
            this.jsCompressorOpt = (String)parser.getOptionValue(jsCompressorOpt, (Object)"yui");
            this.simpleDoctypeOpt = (Boolean)parser.getOptionValue(simpleDoctypeOpt, (Object)false);
            this.removeScriptAttributesOpt = (Boolean)parser.getOptionValue(removeScriptAttributesOpt, (Object)false);
            this.removeStyleAttributesOpt = (Boolean)parser.getOptionValue(removeStyleAttributesOpt, (Object)false);
            this.removeLinkAttributesOpt = (Boolean)parser.getOptionValue(removeLinkAttributesOpt, (Object)false);
            this.removeFormAttributesOpt = (Boolean)parser.getOptionValue(removeFormAttributesOpt, (Object)false);
            this.removeInputAttributesOpt = (Boolean)parser.getOptionValue(removeInputAttributesOpt, (Object)false);
            this.simpleBooleanAttributesOpt = (Boolean)parser.getOptionValue(simpleBooleanAttributesOpt, (Object)false);
            this.removeJavaScriptProtocolOpt = (Boolean)parser.getOptionValue(removeJavaScriptProtocolOpt, (Object)false);
            this.removeHttpProtocolOpt = (Boolean)parser.getOptionValue(removeHttpProtocolOpt, (Object)false);
            this.removeHttpsProtocolOpt = (Boolean)parser.getOptionValue(removeHttpsProtocolOpt, (Object)false);
            this.nomungeOpt = (Boolean)parser.getOptionValue(nomungeOpt, (Object)false);
            this.linebreakOpt = (Integer)parser.getOptionValue(linebreakOpt, (Object)-1);
            this.preserveSemiOpt = (Boolean)parser.getOptionValue(preserveSemiOpt, (Object)false);
            this.disableOptimizationsOpt = (Boolean)parser.getOptionValue(disableOptimizationsOpt, (Object)false);
            this.closureOptLevelOpt = (String)parser.getOptionValue(closureOptLevelOpt, (Object)"simple");
            this.closureCustomExternsOnlyOpt = (Boolean)parser.getOptionValue(closureCustomExternsOnlyOpt, (Object)false);
            this.closureExternsOpt = parser.getOptionValues(closureExternsOpt);
            this.removeSurroundingSpacesOpt = (String)parser.getOptionValue(removeSurroundingSpacesOpt);
            if (this.removeSurroundingSpacesOpt != null) {
                if (this.removeSurroundingSpacesOpt.equalsIgnoreCase("min")) {
                    this.removeSurroundingSpacesOpt = "html,head,body,br,p";
                } else if (this.removeSurroundingSpacesOpt.equalsIgnoreCase("max")) {
                    this.removeSurroundingSpacesOpt = "html,head,body,br,p,h1,h2,h3,h4,h5,h6,blockquote,center,dl,fieldset,form,frame,frameset,hr,noframes,ol,table,tbody,tr,td,th,tfoot,thead,ul";
                } else if (this.removeSurroundingSpacesOpt.equalsIgnoreCase("all")) {
                    this.removeSurroundingSpacesOpt = "all";
                }
            }
            this.fileArgsOpt = parser.getRemainingArgs();
            this.charsetOpt = Charset.isSupported(this.charsetOpt) ? this.charsetOpt : "UTF-8";
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("/?")) continue;
                this.helpOpt = true;
                break;
            }
        }
        catch (CmdLineParser.OptionException e) {
            System.out.println("ERROR: " + e.getMessage());
            this.printUsage();
        }
    }

    public void process(String[] args) {
        try {
            if (this.helpOpt) {
                this.printUsage();
                return;
            }
            String type = this.typeOpt;
            if (type != null && !type.equalsIgnoreCase("html") && !type.equalsIgnoreCase("xml")) {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            if (this.fileArgsOpt.length == 0) {
                if (type == null) {
                    type = "html";
                }
            } else if (type == null) {
                type = this.fileArgsOpt[0].toLowerCase().endsWith(".xml") ? "xml" : "html";
            }
            if (this.analyzeOpt) {
                HtmlAnalyzer analyzer = new HtmlAnalyzer("closure".equalsIgnoreCase(this.jsCompressorOpt) ? "closure" : "yui");
                analyzer.analyze(this.readResource(this.buildReader(this.fileArgsOpt.length > 0 ? this.fileArgsOpt[0] : null)));
            } else {
                Compressor compressor = type.equals("xml") ? this.createXmlCompressor() : this.createHtmlCompressor();
                Map<String, String> ioMap = this.buildInputOutputMap();
                for (Map.Entry<String, String> entry : ioMap.entrySet()) {
                    this.writeResource(compressor.compress(this.readResource(this.buildReader(entry.getKey()))), this.buildWriter(entry.getValue()));
                }
            }
        }
        catch (NoClassDefFoundError e) {
            if ("closure".equalsIgnoreCase(this.jsCompressorOpt)) {
                System.out.println("ERROR: For JavaScript compression using Google Closure Compiler\nadditional jar file called compiler.jar must be present\nin the same directory as HtmlCompressor jar");
            } else {
                System.out.println("ERROR: For CSS or JavaScript compression using YUICompressor additional jar file \ncalled yuicompressor.jar must be present\nin the same directory as HtmlCompressor jar");
            }
        }
        catch (CmdLineParser.OptionException e) {
            System.out.println("ERROR: " + e.getMessage());
            this.printUsage();
        }
        catch (IOException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    private Compressor createHtmlCompressor() throws IllegalArgumentException, CmdLineParser.OptionException {
        boolean useClosureCompressor = "closure".equalsIgnoreCase(this.jsCompressorOpt);
        ArrayList<Pattern> preservePatterns = new ArrayList<Pattern>();
        if (this.preservePhpTagsOpt) {
            preservePatterns.add(HtmlCompressor.PHP_TAG_PATTERN);
        }
        if (this.preserveServerScriptTagsOpt) {
            preservePatterns.add(HtmlCompressor.SERVER_SCRIPT_TAG_PATTERN);
        }
        if (this.preserveSsiTagsOpt) {
            preservePatterns.add(HtmlCompressor.SERVER_SIDE_INCLUDE_PATTERN);
        }
        if (this.patternsFilenameOpt != null) {
            BufferedReader patternsIn = null;
            try {
                patternsIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.patternsFilenameOpt), this.charsetOpt));
                String line = null;
                while ((line = patternsIn.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    try {
                        preservePatterns.add(Pattern.compile(line));
                    }
                    catch (PatternSyntaxException e) {
                        throw new IllegalArgumentException("Regular expression compilation error: " + e.getMessage());
                    }
                }
                this.closeStream(patternsIn);
            }
            catch (IOException e) {
                try {
                    throw new IllegalArgumentException("Unable to read custom pattern definitions file: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    this.closeStream(patternsIn);
                    throw throwable;
                }
            }
        }
        HtmlCompressor htmlCompressor = new HtmlCompressor();
        htmlCompressor.setRemoveComments(!this.preserveCommentsOpt);
        htmlCompressor.setRemoveMultiSpaces(!this.preserveMultiSpacesOpt);
        htmlCompressor.setRemoveIntertagSpaces(this.removeIntertagSpacesOpt);
        htmlCompressor.setRemoveQuotes(this.removeQuotesOpt);
        htmlCompressor.setPreserveLineBreaks(this.preserveLineBreaksOpt);
        htmlCompressor.setCompressJavaScript(this.compressJsOpt);
        htmlCompressor.setCompressCss(this.compressCssOpt);
        htmlCompressor.setSimpleDoctype(this.simpleDoctypeOpt);
        htmlCompressor.setRemoveScriptAttributes(this.removeScriptAttributesOpt);
        htmlCompressor.setRemoveStyleAttributes(this.removeStyleAttributesOpt);
        htmlCompressor.setRemoveLinkAttributes(this.removeLinkAttributesOpt);
        htmlCompressor.setRemoveFormAttributes(this.removeFormAttributesOpt);
        htmlCompressor.setRemoveInputAttributes(this.removeInputAttributesOpt);
        htmlCompressor.setSimpleBooleanAttributes(this.simpleBooleanAttributesOpt);
        htmlCompressor.setRemoveJavaScriptProtocol(this.removeJavaScriptProtocolOpt);
        htmlCompressor.setRemoveHttpProtocol(this.removeHttpProtocolOpt);
        htmlCompressor.setRemoveHttpsProtocol(this.removeHttpsProtocolOpt);
        htmlCompressor.setRemoveSurroundingSpaces(this.removeSurroundingSpacesOpt);
        htmlCompressor.setPreservePatterns(preservePatterns);
        htmlCompressor.setYuiJsNoMunge(this.nomungeOpt);
        htmlCompressor.setYuiJsPreserveAllSemiColons(this.preserveSemiOpt);
        htmlCompressor.setYuiJsDisableOptimizations(this.disableOptimizationsOpt);
        htmlCompressor.setYuiJsLineBreak(this.linebreakOpt);
        htmlCompressor.setYuiCssLineBreak(this.linebreakOpt);
        if (this.compressJsOpt && useClosureCompressor) {
            ClosureJavaScriptCompressor closureCompressor = new ClosureJavaScriptCompressor();
            if (this.closureOptLevelOpt.equalsIgnoreCase("advanced")) {
                closureCompressor.setCompilationLevel(CompilationLevel.ADVANCED_OPTIMIZATIONS);
                closureCompressor.setCustomExternsOnly(this.closureCustomExternsOnlyOpt);
                if (this.closureExternsOpt.size() > 0) {
                    ArrayList<JSSourceFile> externs = new ArrayList<JSSourceFile>();
                    for (String externFile : this.closureExternsOpt) {
                        externs.add(JSSourceFile.fromFile((String)externFile));
                    }
                    closureCompressor.setExterns(externs);
                }
            } else if (this.closureOptLevelOpt.equalsIgnoreCase("whitespace")) {
                closureCompressor.setCompilationLevel(CompilationLevel.WHITESPACE_ONLY);
            } else {
                closureCompressor.setCompilationLevel(CompilationLevel.SIMPLE_OPTIMIZATIONS);
            }
            htmlCompressor.setJavaScriptCompressor(closureCompressor);
        }
        return htmlCompressor;
    }

    private Compressor createXmlCompressor() throws IllegalArgumentException, CmdLineParser.OptionException {
        XmlCompressor xmlCompressor = new XmlCompressor();
        xmlCompressor.setRemoveComments(!this.preserveCommentsOpt);
        xmlCompressor.setRemoveIntertagSpaces(!this.preserveIntertagSpacesOpt);
        return xmlCompressor;
    }

    private Map<String, String> buildInputOutputMap() throws IllegalArgumentException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        File outpuFile = null;
        if (this.outputFilenameOpt != null) {
            outpuFile = new File(this.outputFilenameOpt);
            if (this.outputFilenameOpt.endsWith("/") || this.outputFilenameOpt.endsWith("\\")) {
                outpuFile.mkdirs();
            } else {
                new File(outpuFile.getCanonicalFile().getParent()).mkdirs();
            }
        }
        if (!(this.fileArgsOpt.length <= 1 || outpuFile != null && outpuFile.isDirectory())) {
            throw new IllegalArgumentException("Output must be a directory and end with a slash (/)");
        }
        if (this.fileArgsOpt.length == 0) {
            map.put(null, this.outputFilenameOpt);
        } else {
            for (int i = 0; i < this.fileArgsOpt.length; ++i) {
                if (!urlPattern.matcher(this.fileArgsOpt[i]).matches()) {
                    File inputFile = new File(this.fileArgsOpt[i]);
                    if (inputFile.isDirectory()) {
                        if (outpuFile != null && outpuFile.isDirectory()) {
                            if (!this.recursiveOpt) {
                                for (File file : inputFile.listFiles(new CompressorFileFilter(this.typeOpt, this.filemaskOpt, false))) {
                                    if (file.isDirectory()) continue;
                                    String from = file.getCanonicalPath();
                                    String to = from.replaceFirst(this.escRegEx(inputFile.getCanonicalPath()), Matcher.quoteReplacement(outpuFile.getCanonicalPath()));
                                    map.put(from, to);
                                }
                                continue;
                            }
                            Stack<File> fileStack = new Stack<File>();
                            fileStack.push(inputFile);
                            while (!fileStack.isEmpty()) {
                                File child = (File)fileStack.pop();
                                if (child.isDirectory()) {
                                    for (File f : child.listFiles(new CompressorFileFilter(this.typeOpt, this.filemaskOpt, true))) {
                                        fileStack.push(f);
                                    }
                                    continue;
                                }
                                if (!child.isFile()) continue;
                                String from = child.getCanonicalPath();
                                String to = from.replaceFirst(this.escRegEx(inputFile.getCanonicalPath()), Matcher.quoteReplacement(outpuFile.getCanonicalPath()));
                                map.put(from, to);
                                new File(new File(to).getCanonicalFile().getParent()).mkdirs();
                            }
                            continue;
                        }
                        throw new IllegalArgumentException("Output must be a directory and end with a slash (/)");
                    }
                    if (outpuFile != null && outpuFile.isDirectory()) {
                        String from = inputFile.getCanonicalPath();
                        String to = from.replaceFirst(this.escRegEx(inputFile.getCanonicalFile().getParentFile().getCanonicalPath()), Matcher.quoteReplacement(outpuFile.getCanonicalPath()));
                        map.put(this.fileArgsOpt[i], to);
                        continue;
                    }
                    map.put(this.fileArgsOpt[i], this.outputFilenameOpt);
                    continue;
                }
                if (!(this.fileArgsOpt.length != 1 || outpuFile != null && outpuFile.isDirectory())) {
                    map.put(this.fileArgsOpt[i], this.outputFilenameOpt);
                    continue;
                }
                throw new IllegalArgumentException("Input URL should be single and cannot have directory as output");
            }
        }
        return map;
    }

    private BufferedReader buildReader(String filename) throws IOException {
        if (filename == null) {
            return new BufferedReader(new InputStreamReader(System.in, this.charsetOpt));
        }
        if (urlPattern.matcher(filename).matches()) {
            return new BufferedReader(new InputStreamReader(new URL(filename).openConnection().getInputStream()));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), this.charsetOpt));
    }

    private Writer buildWriter(String filename) throws IOException {
        if (filename == null) {
            return new OutputStreamWriter((OutputStream)System.out, this.charsetOpt);
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(filename), this.charsetOpt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(BufferedReader input) throws IOException {
        StringBuilder source = new StringBuilder();
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                source.append(line);
                source.append(System.getProperty("line.separator"));
            }
        }
        finally {
            this.closeStream(input);
        }
        return source.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResource(String content, Writer output) throws IOException {
        try {
            output.write(content);
        }
        finally {
            this.closeStream(output);
        }
    }

    private void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String escRegEx(String inStr) {
        return inStr.replaceAll("([\\\\*+\\[\\](){}\\$.?\\^|])", "\\\\$1");
    }

    private void printUsage() {
        System.out.println("Usage: java -jar htmlcompressor.jar [options] [input]\n\n[input]                        URL, filename, directory, or space separated list\n                               of files and directories to compress.\n                               If none provided reads from <stdin>\n\nGlobal Options:\n -?, /?, -h, --help            Displays this help screen\n -t, --type <html|xml>         If not provided autodetects from file extension\n -r, --recursive               Process files inside subdirectories\n -c, --charset <charset>       Charset for reading files, UTF-8 by default\n -m, --mask <filemask>         Filter input files inside directories by mask\n -o, --output <path>           Filename or directory for compression results.\n                               If none provided outputs result to <stdout>\n -a, --analyze                 Tries different settings and displays report.\n                               All settings except --js-compressor are ignored\n\nXML Compression Options:\n --preserve-comments           Preserve comments\n --preserve-intertag-spaces    Preserve intertag spaces\n\nHTML Compression Options:\n --preserve-comments           Preserve comments\n --preserve-multi-spaces       Preserve multiple spaces\n --preserve-line-breaks        Preserve line breaks\n --remove-intertag-spaces      Remove intertag spaces\n --remove-quotes               Remove unneeded quotes\n --simple-doctype              Change doctype to <!DOCTYPE html>\n --remove-style-attr           Remove TYPE attribute from STYLE tags\n --remove-link-attr            Remove TYPE attribute from LINK tags\n --remove-script-attr          Remove TYPE and LANGUAGE from SCRIPT tags\n --remove-form-attr            Remove METHOD=\"GET\" from FORM tags\n --remove-input-attr           Remove TYPE=\"TEXT\" from INPUT tags\n --simple-bool-attr            Remove values from boolean tag attributes\n --remove-js-protocol          Remove \"javascript:\" from inline event handlers\n --remove-http-protocol        Remove \"http:\" from tag attributes\n --remove-https-protocol       Remove \"https:\" from tag attributes\n --remove-surrounding-spaces <min|max|all|custom_list>\n                               Predefined or custom comma separated list of tags\n --compress-js                 Enable inline JavaScript compression\n --compress-css                Enable inline CSS compression using YUICompressor\n --js-compressor <yui|closure> Switch inline JavaScript compressor between\n                               YUICompressor (default) and Closure Compiler\n\nJavaScript Compression Options for YUI Compressor:\n --nomunge                     Minify only, do not obfuscate\n --preserve-semi               Preserve all semicolons\n --disable-optimizations       Disable all micro optimizations\n --line-break <column num>     Insert a line break after the specified column\n\nJavaScript Compression Options for Google Closure Compiler:\n --closure-opt-level <simple|advanced|whitespace>\n                               Sets level of optimization (simple by default)\n --closure-externs <file>      Sets custom externs file, repeat for each file\n --closure-custom-externs-only Disable default built-in externs\n\nCSS Compression Options for YUI Compressor:\n --line-break <column num>     Insert a line break after the specified column\n\nCustom Block Preservation Options:\n --preserve-php                Preserve <?php ... ?> tags\n --preserve-server-script      Preserve <% ... %> tags\n --preserve-ssi                Preserve <!--# ... --> tags\n -p, --preserve <path>         Read regular expressions that define\n                               custom preservation rules from a file\n\nPlease note that if you enable CSS or JavaScript compression, additional\nYUI Compressor or Google Closure Compiler jar files must be present\nin the same directory as this jar.");
    }

    private class CompressorFileFilter
    implements FileFilter {
        private Pattern filemaskPattern;
        private boolean withDirs;

        public CompressorFileFilter(String type, String filemask, boolean withDirs) {
            this.withDirs = withDirs;
            if (filemask == null) {
                this.filemaskPattern = type != null && type.equals("xml") ? Pattern.compile("^.*\\.xml$", 2) : Pattern.compile("^.*\\.html?$", 2);
            } else {
                filemask = filemask.replaceAll(CmdLineCompressor.this.escRegEx("."), Matcher.quoteReplacement("\\."));
                filemask = filemask.replaceAll(CmdLineCompressor.this.escRegEx("*"), Matcher.quoteReplacement(".*"));
                filemask = filemask.replaceAll(CmdLineCompressor.this.escRegEx("?"), Matcher.quoteReplacement("."));
                filemask = filemask.replaceAll(CmdLineCompressor.this.escRegEx(";"), Matcher.quoteReplacement("$|^"));
                filemask = "^" + filemask + "$";
                this.filemaskPattern = Pattern.compile(filemask, 2);
            }
        }

        public boolean accept(File file) {
            if (!this.withDirs) {
                if (!file.isDirectory()) {
                    return this.filemaskPattern.matcher(file.getName()).matches();
                }
            } else {
                return file.isDirectory() || this.filemaskPattern.matcher(file.getName()).matches();
            }
            return false;
        }
    }
}

