/*
 * Decompiled with CFR 0.152.
 */
package plan.com.google.htmlcompressor.compressor;

import com.google.common.collect.Lists;
import com.google.common.io.LimitInputStream;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.WarningLevel;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import plan.com.google.htmlcompressor.compressor.Compressor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureJavaScriptCompressor
implements Compressor {
    public static final String COMPILATION_LEVEL_SIMPLE = "simple";
    public static final String COMPILATION_LEVEL_ADVANCED = "advanced";
    public static final String COMPILATION_LEVEL_WHITESPACE = "whitespace";
    private CompilerOptions compilerOptions = new CompilerOptions();
    private CompilationLevel compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
    private Level loggingLevel = Level.SEVERE;
    private WarningLevel warningLevel = WarningLevel.DEFAULT;
    private boolean customExternsOnly = false;
    private List<JSSourceFile> externs = null;

    public ClosureJavaScriptCompressor() {
    }

    public ClosureJavaScriptCompressor(CompilationLevel compilationLevel) {
        this.compilationLevel = compilationLevel;
    }

    @Override
    public String compress(String source) {
        StringWriter writer = new StringWriter();
        ArrayList<JSSourceFile> input = new ArrayList<JSSourceFile>();
        input.add(JSSourceFile.fromCode((String)"source.js", (String)source));
        List<Object> externsList = new ArrayList<JSSourceFile>();
        if (this.compilationLevel.equals((Object)CompilationLevel.ADVANCED_OPTIMIZATIONS)) {
            if (!this.customExternsOnly) {
                try {
                    externsList = this.getDefaultExterns();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.externs != null) {
                for (JSSourceFile extern : this.externs) {
                    externsList.add(extern);
                }
            }
            if (externsList.size() == 0) {
                externsList.add(JSSourceFile.fromCode((String)"externs.js", (String)""));
            }
        } else {
            externsList.add(JSSourceFile.fromCode((String)"externs.js", (String)""));
        }
        Compiler.setLoggingLevel((Level)this.loggingLevel);
        Compiler compiler = new Compiler();
        compiler.disableThreads();
        this.compilationLevel.setOptionsForCompilationLevel(this.compilerOptions);
        this.warningLevel.setOptionsForWarningLevel(this.compilerOptions);
        Result result = compiler.compile(externsList, input, this.compilerOptions);
        if (result.success) {
            writer.write(compiler.toSource());
        } else {
            writer.write(source);
        }
        return writer.toString();
    }

    private List<JSSourceFile> getDefaultExterns() throws IOException {
        InputStream input = ClosureJavaScriptCompressor.class.getResourceAsStream("/externs.zip");
        ZipInputStream zip = new ZipInputStream(input);
        LinkedList externs = Lists.newLinkedList();
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            LimitInputStream entryStream = new LimitInputStream((InputStream)zip, entry.getSize());
            externs.add(JSSourceFile.fromInputStream((String)entry.getName(), (InputStream)entryStream));
        }
        return externs;
    }

    public CompilationLevel getCompilationLevel() {
        return this.compilationLevel;
    }

    public void setCompilationLevel(CompilationLevel compilationLevel) {
        this.compilationLevel = compilationLevel;
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public void setCompilerOptions(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(Level loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public List<JSSourceFile> getExterns() {
        return this.externs;
    }

    public void setExterns(List<JSSourceFile> externs) {
        this.externs = externs;
    }

    public WarningLevel getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(WarningLevel warningLevel) {
        this.warningLevel = warningLevel;
    }

    public boolean isCustomExternsOnly() {
        return this.customExternsOnly;
    }

    public void setCustomExternsOnly(boolean customExternsOnly) {
        this.customExternsOnly = customExternsOnly;
    }
}

