/*
 * Decompiled with CFR 0.152.
 */
package plan.com.google.htmlcompressor.taglib;

import com.google.javascript.jscomp.CompilationLevel;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import plan.com.google.htmlcompressor.compressor.ClosureJavaScriptCompressor;
import plan.com.google.htmlcompressor.compressor.HtmlCompressor;

public class HtmlCompressorTag
extends BodyTagSupport {
    private boolean enabled = true;
    private boolean removeComments = true;
    private boolean removeMultiSpaces = true;
    private boolean removeIntertagSpaces = false;
    private boolean removeQuotes = false;
    private boolean preserveLineBreaks = false;
    private boolean simpleDoctype = false;
    private boolean removeScriptAttributes = false;
    private boolean removeStyleAttributes = false;
    private boolean removeLinkAttributes = false;
    private boolean removeFormAttributes = false;
    private boolean removeInputAttributes = false;
    private boolean simpleBooleanAttributes = false;
    private boolean removeJavaScriptProtocol = false;
    private boolean removeHttpProtocol = false;
    private boolean removeHttpsProtocol = false;
    private boolean compressJavaScript = false;
    private boolean compressCss = false;
    private String jsCompressor = "yui";
    private boolean yuiJsNoMunge = false;
    private boolean yuiJsPreserveAllSemiColons = false;
    private boolean yuiJsDisableOptimizations = false;
    private int yuiJsLineBreak = -1;
    private int yuiCssLineBreak = -1;
    private String closureOptLevel = "simple";

    public int doEndTag() throws JspException {
        BodyContent bodyContent = this.getBodyContent();
        String content = bodyContent.getString();
        HtmlCompressor htmlCompressor = new HtmlCompressor();
        htmlCompressor.setEnabled(this.enabled);
        htmlCompressor.setRemoveComments(this.removeComments);
        htmlCompressor.setRemoveMultiSpaces(this.removeMultiSpaces);
        htmlCompressor.setRemoveIntertagSpaces(this.removeIntertagSpaces);
        htmlCompressor.setRemoveQuotes(this.removeQuotes);
        htmlCompressor.setPreserveLineBreaks(this.preserveLineBreaks);
        htmlCompressor.setCompressJavaScript(this.compressJavaScript);
        htmlCompressor.setCompressCss(this.compressCss);
        htmlCompressor.setYuiJsNoMunge(this.yuiJsNoMunge);
        htmlCompressor.setYuiJsPreserveAllSemiColons(this.yuiJsPreserveAllSemiColons);
        htmlCompressor.setYuiJsDisableOptimizations(this.yuiJsDisableOptimizations);
        htmlCompressor.setYuiJsLineBreak(this.yuiJsLineBreak);
        htmlCompressor.setYuiCssLineBreak(this.yuiCssLineBreak);
        htmlCompressor.setSimpleDoctype(this.simpleDoctype);
        htmlCompressor.setRemoveScriptAttributes(this.removeScriptAttributes);
        htmlCompressor.setRemoveStyleAttributes(this.removeStyleAttributes);
        htmlCompressor.setRemoveLinkAttributes(this.removeLinkAttributes);
        htmlCompressor.setRemoveFormAttributes(this.removeFormAttributes);
        htmlCompressor.setRemoveInputAttributes(this.removeInputAttributes);
        htmlCompressor.setSimpleBooleanAttributes(this.simpleBooleanAttributes);
        htmlCompressor.setRemoveJavaScriptProtocol(this.removeJavaScriptProtocol);
        htmlCompressor.setRemoveHttpProtocol(this.removeHttpProtocol);
        htmlCompressor.setRemoveHttpsProtocol(this.removeHttpsProtocol);
        if (this.compressJavaScript && this.jsCompressor.equalsIgnoreCase("closure")) {
            ClosureJavaScriptCompressor closureCompressor = new ClosureJavaScriptCompressor();
            if (this.closureOptLevel.equalsIgnoreCase("advanced")) {
                closureCompressor.setCompilationLevel(CompilationLevel.ADVANCED_OPTIMIZATIONS);
            } else if (this.closureOptLevel.equalsIgnoreCase("whitespace")) {
                closureCompressor.setCompilationLevel(CompilationLevel.WHITESPACE_ONLY);
            } else {
                closureCompressor.setCompilationLevel(CompilationLevel.SIMPLE_OPTIMIZATIONS);
            }
            htmlCompressor.setJavaScriptCompressor(closureCompressor);
        }
        try {
            bodyContent.clear();
            bodyContent.append((CharSequence)htmlCompressor.compress(content));
            bodyContent.writeOut((Writer)this.pageContext.getOut());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.doEndTag();
    }

    public void setCompressJavaScript(boolean compressJavaScript) {
        this.compressJavaScript = compressJavaScript;
    }

    public void setCompressCss(boolean compressCss) {
        this.compressCss = compressCss;
    }

    public void setYuiJsNoMunge(boolean yuiJsNoMunge) {
        this.yuiJsNoMunge = yuiJsNoMunge;
    }

    public void setYuiJsPreserveAllSemiColons(boolean yuiJsPreserveAllSemiColons) {
        this.yuiJsPreserveAllSemiColons = yuiJsPreserveAllSemiColons;
    }

    public void setYuiJsDisableOptimizations(boolean yuiJsDisableOptimizations) {
        this.yuiJsDisableOptimizations = yuiJsDisableOptimizations;
    }

    public void setYuiJsLineBreak(int yuiJsLineBreak) {
        this.yuiJsLineBreak = yuiJsLineBreak;
    }

    public void setYuiCssLineBreak(int yuiCssLineBreak) {
        this.yuiCssLineBreak = yuiCssLineBreak;
    }

    public void setRemoveQuotes(boolean removeQuotes) {
        this.removeQuotes = removeQuotes;
    }

    public void setPreserveLineBreaks(boolean preserveLineBreaks) {
        this.preserveLineBreaks = preserveLineBreaks;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRemoveComments(boolean removeComments) {
        this.removeComments = removeComments;
    }

    public void setRemoveMultiSpaces(boolean removeMultiSpaces) {
        this.removeMultiSpaces = removeMultiSpaces;
    }

    public void setRemoveIntertagSpaces(boolean removeIntertagSpaces) {
        this.removeIntertagSpaces = removeIntertagSpaces;
    }

    public void setJsCompressor(String jsCompressor) {
        this.jsCompressor = jsCompressor;
    }

    public void setClosureOptLevel(String closureOptLevel) {
        this.closureOptLevel = closureOptLevel;
    }

    public void setSimpleDoctype(boolean simpleDoctype) {
        this.simpleDoctype = simpleDoctype;
    }

    public void setRemoveScriptAttributes(boolean removeScriptAttributes) {
        this.removeScriptAttributes = removeScriptAttributes;
    }

    public void setRemoveStyleAttributes(boolean removeStyleAttributes) {
        this.removeStyleAttributes = removeStyleAttributes;
    }

    public void setRemoveLinkAttributes(boolean removeLinkAttributes) {
        this.removeLinkAttributes = removeLinkAttributes;
    }

    public void setRemoveFormAttributes(boolean removeFormAttributes) {
        this.removeFormAttributes = removeFormAttributes;
    }

    public void setRemoveInputAttributes(boolean removeInputAttributes) {
        this.removeInputAttributes = removeInputAttributes;
    }

    public void setSimpleBooleanAttributes(boolean simpleBooleanAttributes) {
        this.simpleBooleanAttributes = simpleBooleanAttributes;
    }

    public void setRemoveJavaScriptProtocol(boolean removeJavaScriptProtocol) {
        this.removeJavaScriptProtocol = removeJavaScriptProtocol;
    }

    public void setRemoveHttpProtocol(boolean removeHttpProtocol) {
        this.removeHttpProtocol = removeHttpProtocol;
    }

    public void setRemoveHttpsProtocol(boolean removeHttpsProtocol) {
        this.removeHttpsProtocol = removeHttpsProtocol;
    }
}

