/*
 * Decompiled with CFR 0.152.
 */
package plan.com.google.htmlcompressor.velocity;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import plan.com.google.htmlcompressor.compressor.YuiCssCompressor;
import plan.org.apache.velocity.context.InternalContextAdapter;
import plan.org.apache.velocity.exception.MethodInvocationException;
import plan.org.apache.velocity.exception.ParseErrorException;
import plan.org.apache.velocity.exception.ResourceNotFoundException;
import plan.org.apache.velocity.exception.TemplateInitException;
import plan.org.apache.velocity.runtime.RuntimeServices;
import plan.org.apache.velocity.runtime.directive.Directive;
import plan.org.apache.velocity.runtime.log.Log;
import plan.org.apache.velocity.runtime.parser.node.Node;

public class CssCompressorDirective
extends Directive {
    private Log log;
    private boolean enabled = true;
    private int yuiCssLineBreak = -1;

    public String getName() {
        return "compressCss";
    }

    public int getType() {
        return 1;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        this.log = rs.getLog();
        this.enabled = rs.getBoolean("userdirective.compressCss.enabled", true);
        this.yuiCssLineBreak = rs.getInt("userdirective.compressCss.yuiCssLineBreak", -1);
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        StringWriter content = new StringWriter();
        node.jjtGetChild(0).render(context, (Writer)content);
        if (this.enabled) {
            try {
                YuiCssCompressor compressor = new YuiCssCompressor();
                compressor.setLineBreak(this.yuiCssLineBreak);
                String result = compressor.compress(content.toString());
                writer.write(result);
            }
            catch (Exception e) {
                writer.write(content.toString());
                String msg = "Failed to compress content: " + content.toString();
                this.log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        } else {
            writer.write(content.toString());
        }
        return true;
    }
}

