/*
 * Decompiled with CFR 0.152.
 */
package plan.com.google.htmlcompressor.velocity;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import plan.com.google.htmlcompressor.compressor.XmlCompressor;
import plan.org.apache.velocity.context.InternalContextAdapter;
import plan.org.apache.velocity.exception.MethodInvocationException;
import plan.org.apache.velocity.exception.ParseErrorException;
import plan.org.apache.velocity.exception.ResourceNotFoundException;
import plan.org.apache.velocity.exception.TemplateInitException;
import plan.org.apache.velocity.runtime.RuntimeServices;
import plan.org.apache.velocity.runtime.directive.Directive;
import plan.org.apache.velocity.runtime.log.Log;
import plan.org.apache.velocity.runtime.parser.node.Node;

public class XmlCompressorDirective
extends Directive {
    private static final XmlCompressor xmlCompressor = new XmlCompressor();
    private Log log;

    public String getName() {
        return "compressXml";
    }

    public int getType() {
        return 1;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        this.log = rs.getLog();
        xmlCompressor.setEnabled(rs.getBoolean("userdirective.compressXml.enabled", true));
        xmlCompressor.setRemoveComments(rs.getBoolean("userdirective.compressXml.removeComments", true));
        xmlCompressor.setRemoveIntertagSpaces(rs.getBoolean("userdirective.compressXml.removeIntertagSpaces", true));
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        StringWriter content = new StringWriter();
        node.jjtGetChild(0).render(context, (Writer)content);
        try {
            writer.write(xmlCompressor.compress(content.toString()));
        }
        catch (Exception e) {
            writer.write(content.toString());
            String msg = "Failed to compress content: " + content.toString();
            this.log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        return true;
    }
}

