/*
 * Decompiled with CFR 0.152.
 */
package plan.com.maxmind.geoip2;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import plan.com.fasterxml.jackson.databind.DeserializationFeature;
import plan.com.fasterxml.jackson.databind.JsonNode;
import plan.com.fasterxml.jackson.databind.MapperFeature;
import plan.com.fasterxml.jackson.databind.ObjectMapper;
import plan.com.fasterxml.jackson.databind.node.ObjectNode;
import plan.com.maxmind.db.InvalidDatabaseException;
import plan.com.maxmind.db.Metadata;
import plan.com.maxmind.db.NoCache;
import plan.com.maxmind.db.NodeCache;
import plan.com.maxmind.db.Reader;
import plan.com.maxmind.db.Record;
import plan.com.maxmind.geoip2.DatabaseProvider;
import plan.com.maxmind.geoip2.JsonInjector;
import plan.com.maxmind.geoip2.exception.AddressNotFoundException;
import plan.com.maxmind.geoip2.exception.GeoIp2Exception;
import plan.com.maxmind.geoip2.model.AnonymousIpResponse;
import plan.com.maxmind.geoip2.model.AsnResponse;
import plan.com.maxmind.geoip2.model.CityResponse;
import plan.com.maxmind.geoip2.model.ConnectionTypeResponse;
import plan.com.maxmind.geoip2.model.CountryResponse;
import plan.com.maxmind.geoip2.model.DomainResponse;
import plan.com.maxmind.geoip2.model.EnterpriseResponse;
import plan.com.maxmind.geoip2.model.IspResponse;

public class DatabaseReader
implements DatabaseProvider,
Closeable {
    private final Reader reader;
    private final ObjectMapper om;
    private final List<String> locales;
    private final int databaseType;

    private DatabaseReader(Builder builder) throws IOException {
        if (builder.stream != null) {
            this.reader = new Reader(builder.stream, builder.cache);
        } else if (builder.database != null) {
            this.reader = new Reader(builder.database, builder.mode, builder.cache);
        } else {
            throw new IllegalArgumentException("Unsupported Builder configuration: expected either File or URL");
        }
        this.om = new ObjectMapper();
        this.om.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, false);
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.om.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        this.locales = builder.locales;
        this.databaseType = this.getDatabaseType();
    }

    private int getDatabaseType() {
        String databaseType = this.getMetadata().getDatabaseType();
        int type = 0;
        if (databaseType.contains("GeoIP2-Anonymous-IP")) {
            type |= DatabaseType.ANONYMOUS_IP.type;
        }
        if (databaseType.contains("GeoLite2-ASN")) {
            type |= DatabaseType.ASN.type;
        }
        if (databaseType.contains("City")) {
            type |= DatabaseType.CITY.type | DatabaseType.COUNTRY.type;
        }
        if (databaseType.contains("GeoIP2-Connection-Type")) {
            type |= DatabaseType.CONNECTION_TYPE.type;
        }
        if (databaseType.contains("Country")) {
            type |= DatabaseType.COUNTRY.type;
        }
        if (databaseType.contains("GeoIP2-Domain")) {
            type |= DatabaseType.DOMAIN.type;
        }
        if (databaseType.contains("Enterprise")) {
            type |= DatabaseType.ENTERPRISE.type | DatabaseType.CITY.type | DatabaseType.COUNTRY.type;
        }
        if (databaseType.contains("GeoIP2-ISP")) {
            type |= DatabaseType.ISP.type;
        }
        if (type == 0) {
            throw new UnsupportedOperationException("Invalid attempt to open an unknown database type: " + databaseType);
        }
        return type;
    }

    private <T> T getOrThrowException(InetAddress ipAddress, Class<T> cls, DatabaseType expectedType) throws IOException, AddressNotFoundException {
        Optional<T> t = this.get(ipAddress, cls, expectedType, 1);
        if (!t.isPresent()) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        return t.get();
    }

    private <T> Optional<T> get(InetAddress ipAddress, Class<T> cls, DatabaseType expectedType, int stackDepth) throws IOException, AddressNotFoundException {
        if ((this.databaseType & expectedType.type) == 0) {
            String caller = Thread.currentThread().getStackTrace()[2 + stackDepth].getMethodName();
            throw new UnsupportedOperationException("Invalid attempt to open a " + this.getMetadata().getDatabaseType() + " database using the " + caller + " method");
        }
        Record record = this.reader.getRecord(ipAddress);
        ObjectNode node = this.jsonNodeToObjectNode(record.getData());
        if (node == null) {
            return Optional.empty();
        }
        JsonInjector inject = new JsonInjector(this.locales, ipAddress.getHostAddress(), record.getNetwork());
        return Optional.of(this.om.reader(inject).treeToValue(node, cls));
    }

    private ObjectNode jsonNodeToObjectNode(JsonNode node) throws InvalidDatabaseException {
        if (node == null || node instanceof ObjectNode) {
            return (ObjectNode)node;
        }
        throw new InvalidDatabaseException("Unexpected data type returned. The GeoIP2 database may be corrupt.");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public CountryResponse country(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getOrThrowException(ipAddress, CountryResponse.class, DatabaseType.COUNTRY);
    }

    @Override
    public Optional<CountryResponse> tryCountry(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, CountryResponse.class, DatabaseType.COUNTRY, 0);
    }

    @Override
    public CityResponse city(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getOrThrowException(ipAddress, CityResponse.class, DatabaseType.CITY);
    }

    @Override
    public Optional<CityResponse> tryCity(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, CityResponse.class, DatabaseType.CITY, 0);
    }

    @Override
    public AnonymousIpResponse anonymousIp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getOrThrowException(ipAddress, AnonymousIpResponse.class, DatabaseType.ANONYMOUS_IP);
    }

    @Override
    public Optional<AnonymousIpResponse> tryAnonymousIp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, AnonymousIpResponse.class, DatabaseType.ANONYMOUS_IP, 0);
    }

    @Override
    public AsnResponse asn(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getOrThrowException(ipAddress, AsnResponse.class, DatabaseType.ASN);
    }

    @Override
    public Optional<AsnResponse> tryAsn(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, AsnResponse.class, DatabaseType.ASN, 0);
    }

    @Override
    public ConnectionTypeResponse connectionType(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getOrThrowException(ipAddress, ConnectionTypeResponse.class, DatabaseType.CONNECTION_TYPE);
    }

    @Override
    public Optional<ConnectionTypeResponse> tryConnectionType(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, ConnectionTypeResponse.class, DatabaseType.CONNECTION_TYPE, 0);
    }

    @Override
    public DomainResponse domain(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getOrThrowException(ipAddress, DomainResponse.class, DatabaseType.DOMAIN);
    }

    @Override
    public Optional<DomainResponse> tryDomain(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, DomainResponse.class, DatabaseType.DOMAIN, 0);
    }

    @Override
    public EnterpriseResponse enterprise(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getOrThrowException(ipAddress, EnterpriseResponse.class, DatabaseType.ENTERPRISE);
    }

    @Override
    public Optional<EnterpriseResponse> tryEnterprise(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, EnterpriseResponse.class, DatabaseType.ENTERPRISE, 0);
    }

    @Override
    public IspResponse isp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getOrThrowException(ipAddress, IspResponse.class, DatabaseType.ISP);
    }

    @Override
    public Optional<IspResponse> tryIsp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, IspResponse.class, DatabaseType.ISP, 0);
    }

    public Metadata getMetadata() {
        return this.reader.getMetadata();
    }

    public static final class Builder {
        final File database;
        final InputStream stream;
        List<String> locales = Collections.singletonList("en");
        Reader.FileMode mode = Reader.FileMode.MEMORY_MAPPED;
        NodeCache cache = NoCache.getInstance();

        public Builder(InputStream stream) {
            this.stream = stream;
            this.database = null;
        }

        public Builder(File database) {
            this.database = database;
            this.stream = null;
        }

        public Builder locales(List<String> val) {
            this.locales = val;
            return this;
        }

        public Builder withCache(NodeCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder fileMode(Reader.FileMode val) {
            if (this.stream != null && Reader.FileMode.MEMORY != val) {
                throw new IllegalArgumentException("Only FileMode.MEMORY is supported when using an InputStream.");
            }
            this.mode = val;
            return this;
        }

        public DatabaseReader build() throws IOException {
            return new DatabaseReader(this);
        }
    }

    private static enum DatabaseType {
        ANONYMOUS_IP,
        ASN,
        CITY,
        CONNECTION_TYPE,
        COUNTRY,
        DOMAIN,
        ENTERPRISE,
        ISP;

        final int type = 1 << this.ordinal();
    }
}

