/*
 * Decompiled with CFR 0.152.
 */
package plan.com.maxmind.geoip2;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plan.com.fasterxml.jackson.core.type.TypeReference;
import plan.com.fasterxml.jackson.databind.DeserializationFeature;
import plan.com.fasterxml.jackson.databind.MapperFeature;
import plan.com.fasterxml.jackson.databind.ObjectMapper;
import plan.com.maxmind.geoip2.GeoIp2Provider;
import plan.com.maxmind.geoip2.JsonInjector;
import plan.com.maxmind.geoip2.exception.AddressNotFoundException;
import plan.com.maxmind.geoip2.exception.AuthenticationException;
import plan.com.maxmind.geoip2.exception.GeoIp2Exception;
import plan.com.maxmind.geoip2.exception.HttpException;
import plan.com.maxmind.geoip2.exception.InvalidRequestException;
import plan.com.maxmind.geoip2.exception.OutOfQueriesException;
import plan.com.maxmind.geoip2.exception.PermissionRequiredException;
import plan.com.maxmind.geoip2.model.CityResponse;
import plan.com.maxmind.geoip2.model.CountryResponse;
import plan.com.maxmind.geoip2.model.InsightsResponse;
import plan.org.apache.http.HttpEntity;
import plan.org.apache.http.HttpHost;
import plan.org.apache.http.HttpResponse;
import plan.org.apache.http.auth.UsernamePasswordCredentials;
import plan.org.apache.http.client.config.RequestConfig;
import plan.org.apache.http.client.methods.CloseableHttpResponse;
import plan.org.apache.http.client.methods.HttpGet;
import plan.org.apache.http.client.utils.URIBuilder;
import plan.org.apache.http.impl.auth.BasicScheme;
import plan.org.apache.http.impl.client.CloseableHttpClient;
import plan.org.apache.http.impl.client.HttpClientBuilder;
import plan.org.apache.http.util.EntityUtils;

public class WebServiceClient
implements GeoIp2Provider,
Closeable {
    private final String host;
    private final List<String> locales;
    private final String licenseKey;
    private final int accountId;
    private final boolean useHttps;
    private final int port;
    private final ObjectMapper mapper;
    private final CloseableHttpClient httpClient;

    private WebServiceClient(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.useHttps = builder.useHttps;
        this.locales = builder.locales;
        this.licenseKey = builder.licenseKey;
        this.accountId = builder.accountId;
        this.mapper = new ObjectMapper();
        this.mapper.disable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        RequestConfig.Builder configBuilder = RequestConfig.custom().setConnectTimeout(builder.connectTimeout).setSocketTimeout(builder.readTimeout);
        if (builder.proxy != null && builder.proxy != Proxy.NO_PROXY) {
            InetSocketAddress address = (InetSocketAddress)builder.proxy.address();
            HttpHost proxyHost = new HttpHost(address.getHostName(), address.getPort());
            configBuilder.setProxy(proxyHost);
        }
        RequestConfig config = configBuilder.build();
        this.httpClient = HttpClientBuilder.create().setUserAgent(this.userAgent()).setDefaultRequestConfig(config).build();
    }

    public CountryResponse country() throws IOException, GeoIp2Exception {
        return this.country(null);
    }

    @Override
    public CountryResponse country(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.responseFor("country", ipAddress, CountryResponse.class);
    }

    public CityResponse city() throws IOException, GeoIp2Exception {
        return this.city(null);
    }

    @Override
    public CityResponse city(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.responseFor("city", ipAddress, CityResponse.class);
    }

    public InsightsResponse insights() throws IOException, GeoIp2Exception {
        return this.insights(null);
    }

    public InsightsResponse insights(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.responseFor("insights", ipAddress, InsightsResponse.class);
    }

    private <T> T responseFor(String path, InetAddress ipAddress, Class<T> cls) throws IOException, GeoIp2Exception {
        URL url = this.createUri(path, ipAddress);
        HttpGet request = this.getResponse(url);
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            T t = this.handleResponse(response, url, cls);
            return t;
        }
    }

    private HttpGet getResponse(URL url) throws GeoIp2Exception, IOException {
        HttpGet request;
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(Integer.toString(this.accountId), this.licenseKey);
        try {
            request = new HttpGet(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new GeoIp2Exception("Error parsing request URL", e);
        }
        try {
            request.addHeader(new BasicScheme().authenticate(credentials, request, null));
        }
        catch (plan.org.apache.http.auth.AuthenticationException e) {
            throw new AuthenticationException("Error setting up request authentication", e);
        }
        request.addHeader("Accept", "application/json");
        return request;
    }

    private <T> T handleResponse(CloseableHttpResponse response, URL url, Class<T> cls) throws GeoIp2Exception, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 400 && status < 500) {
            this.handle4xxStatus(response, url);
        } else {
            if (status >= 500 && status < 600) {
                throw new HttpException("Received a server error (" + status + ") for " + url, status, url);
            }
            if (status != 200) {
                throw new HttpException("Received an unexpected HTTP status (" + status + ") for " + url, status, url);
            }
        }
        JsonInjector inject = new JsonInjector(this.locales, null, null);
        HttpEntity entity = response.getEntity();
        try {
            Object t = this.mapper.readerFor(cls).with(inject).readValue(entity.getContent());
            return t;
        }
        catch (IOException e) {
            throw new GeoIp2Exception("Received a 200 response but could not decode it as JSON", e);
        }
        finally {
            EntityUtils.consume(entity);
        }
    }

    private void handle4xxStatus(HttpResponse response, URL url) throws GeoIp2Exception, IOException {
        HttpEntity entity = response.getEntity();
        int status = response.getStatusLine().getStatusCode();
        if (entity.getContentLength() == 0L) {
            throw new HttpException("Received a " + status + " error for " + url + " with no body", status, url);
        }
        String body = EntityUtils.toString(entity, "UTF-8");
        try {
            Map content = this.mapper.readValue(body, new TypeReference<HashMap<String, String>>(){});
            WebServiceClient.handleErrorWithJsonBody(content, body, status, url);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HttpException("Received a " + status + " error for " + url + " but it did not include the expected JSON body: " + body, status, url);
        }
    }

    private static void handleErrorWithJsonBody(Map<String, String> content, String body, int status, URL url) throws GeoIp2Exception, HttpException {
        String error = content.get("error");
        String code = content.get("code");
        if (error == null || code == null) {
            throw new HttpException("Error response contains JSON but it does not specify code or error keys: " + body, status, url);
        }
        switch (code) {
            case "IP_ADDRESS_NOT_FOUND": 
            case "IP_ADDRESS_RESERVED": {
                throw new AddressNotFoundException(error);
            }
            case "ACCOUNT_ID_REQUIRED": 
            case "ACCOUNT_ID_UNKNOWN": 
            case "AUTHORIZATION_INVALID": 
            case "LICENSE_KEY_REQUIRED": 
            case "USER_ID_REQUIRED": 
            case "USER_ID_UNKNOWN": {
                throw new AuthenticationException(error);
            }
            case "INSUFFICIENT_FUNDS": 
            case "OUT_OF_QUERIES": {
                throw new OutOfQueriesException(error);
            }
            case "PERMISSION_REQUIRED": {
                throw new PermissionRequiredException(error);
            }
        }
        throw new InvalidRequestException(error, code, url);
    }

    private URL createUri(String service, InetAddress ipAddress) throws GeoIp2Exception {
        try {
            return new URIBuilder().setScheme(this.useHttps ? "https" : "http").setHost(this.host).setPort(this.port).setPath("/geoip/v2.1/" + service + "/" + (ipAddress == null ? "me" : ipAddress.getHostAddress())).build().toURL();
        }
        catch (MalformedURLException e) {
            throw new GeoIp2Exception("Malformed service URL", e);
        }
        catch (URISyntaxException e) {
            throw new GeoIp2Exception("Syntax error creating service URL", e);
        }
    }

    private String userAgent() {
        return "GeoIP2/" + this.getClass().getPackage().getImplementationVersion() + " (Java/" + System.getProperty("java.version") + ")";
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public String toString() {
        return "WebServiceClient{, host='" + this.host + '\'' + ", locales=" + this.locales + ", licenseKey='" + this.licenseKey + '\'' + ", accountId=" + this.accountId + ", useHttps=" + this.useHttps + ", port=" + this.port + ", mapper=" + this.mapper + ", httpClient=" + this.httpClient + '}';
    }

    public static final class Builder {
        final int accountId;
        final String licenseKey;
        String host = "geoip.maxmind.com";
        int port = 443;
        boolean useHttps = true;
        int connectTimeout = 3000;
        int readTimeout = 20000;
        List<String> locales = Collections.singletonList("en");
        private Proxy proxy;

        public Builder(int accountId, String licenseKey) {
            this.accountId = accountId;
            this.licenseKey = licenseKey;
        }

        public Builder connectTimeout(int val) {
            this.connectTimeout = val;
            return this;
        }

        public Builder disableHttps() {
            this.useHttps = false;
            return this;
        }

        public Builder host(String val) {
            this.host = val;
            return this;
        }

        public Builder port(int val) {
            this.port = val;
            return this;
        }

        public Builder locales(List<String> val) {
            this.locales = new ArrayList<String>(val);
            return this;
        }

        public Builder readTimeout(int val) {
            this.readTimeout = val;
            return this;
        }

        public Builder proxy(Proxy val) {
            this.proxy = val;
            return this;
        }

        public WebServiceClient build() {
            return new WebServiceClient(this);
        }
    }
}

