/*
 * Decompiled with CFR 0.152.
 */
package plan.com.mysql.cj.protocol;

import java.util.LinkedList;
import plan.com.mysql.cj.MessageBuilder;
import plan.com.mysql.cj.Messages;
import plan.com.mysql.cj.Session;
import plan.com.mysql.cj.TransactionEventHandler;
import plan.com.mysql.cj.conf.PropertyKey;
import plan.com.mysql.cj.conf.PropertySet;
import plan.com.mysql.cj.exceptions.ExceptionInterceptor;
import plan.com.mysql.cj.log.Log;
import plan.com.mysql.cj.protocol.AuthenticationProvider;
import plan.com.mysql.cj.protocol.Message;
import plan.com.mysql.cj.protocol.PacketReceivedTimeHolder;
import plan.com.mysql.cj.protocol.PacketSentTimeHolder;
import plan.com.mysql.cj.protocol.Protocol;
import plan.com.mysql.cj.protocol.SocketConnection;
import plan.com.mysql.cj.util.TimeUtil;

public abstract class AbstractProtocol<M extends Message>
implements Protocol<M> {
    protected Session session;
    protected SocketConnection socketConnection;
    protected PropertySet propertySet;
    protected TransactionEventHandler transactionManager;
    protected transient Log log;
    protected ExceptionInterceptor exceptionInterceptor;
    protected AuthenticationProvider<M> authProvider;
    protected MessageBuilder<M> messageBuilder;
    private PacketSentTimeHolder packetSentTimeHolder = new PacketSentTimeHolder(){};
    private PacketReceivedTimeHolder packetReceivedTimeHolder = new PacketReceivedTimeHolder(){};
    protected LinkedList<StringBuilder> packetDebugRingBuffer = null;
    protected boolean useNanosForElapsedTime;
    protected String queryTimingUnits;

    @Override
    public void init(Session sess, SocketConnection phConnection, PropertySet propSet, TransactionEventHandler trManager) {
        this.session = sess;
        this.propertySet = propSet;
        this.socketConnection = phConnection;
        this.exceptionInterceptor = this.socketConnection.getExceptionInterceptor();
        this.transactionManager = trManager;
        this.useNanosForElapsedTime = this.propertySet.getBooleanProperty(PropertyKey.useNanosForElapsedTime).getValue() != false && TimeUtil.nanoTimeAvailable();
        this.queryTimingUnits = this.useNanosForElapsedTime ? Messages.getString("Nanoseconds") : Messages.getString("Milliseconds");
    }

    @Override
    public SocketConnection getSocketConnection() {
        return this.socketConnection;
    }

    @Override
    public AuthenticationProvider<M> getAuthenticationProvider() {
        return this.authProvider;
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    @Override
    public PacketSentTimeHolder getPacketSentTimeHolder() {
        return this.packetSentTimeHolder;
    }

    @Override
    public void setPacketSentTimeHolder(PacketSentTimeHolder packetSentTimeHolder) {
        this.packetSentTimeHolder = packetSentTimeHolder;
    }

    @Override
    public PacketReceivedTimeHolder getPacketReceivedTimeHolder() {
        return this.packetReceivedTimeHolder;
    }

    @Override
    public void setPacketReceivedTimeHolder(PacketReceivedTimeHolder packetReceivedTimeHolder) {
        this.packetReceivedTimeHolder = packetReceivedTimeHolder;
    }

    @Override
    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    @Override
    public void setPropertySet(PropertySet propertySet) {
        this.propertySet = propertySet;
    }

    @Override
    public MessageBuilder<M> getMessageBuilder() {
        return this.messageBuilder;
    }

    @Override
    public void reset() {
    }

    @Override
    public String getQueryTimingUnits() {
        return this.queryTimingUnits;
    }
}

