/*
 * Decompiled with CFR 0.152.
 */
package plan.com.mysql.cj.protocol;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import plan.com.mysql.cj.Messages;
import plan.com.mysql.cj.conf.PropertySet;
import plan.com.mysql.cj.exceptions.CJException;
import plan.com.mysql.cj.exceptions.ExceptionFactory;
import plan.com.mysql.cj.exceptions.ExceptionInterceptor;
import plan.com.mysql.cj.exceptions.UnableToConnectException;
import plan.com.mysql.cj.protocol.ExportControlled;
import plan.com.mysql.cj.protocol.FullReadInputStream;
import plan.com.mysql.cj.protocol.NetworkResources;
import plan.com.mysql.cj.protocol.SocketConnection;
import plan.com.mysql.cj.protocol.SocketFactory;
import plan.com.mysql.jdbc.SocketFactoryWrapper;

public abstract class AbstractSocketConnection
implements SocketConnection {
    protected String host = null;
    protected int port = 3306;
    protected SocketFactory socketFactory = null;
    protected Socket mysqlSocket = null;
    protected FullReadInputStream mysqlInput = null;
    protected BufferedOutputStream mysqlOutput = null;
    protected ExceptionInterceptor exceptionInterceptor;
    protected PropertySet propertySet;

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Socket getMysqlSocket() {
        return this.mysqlSocket;
    }

    @Override
    public FullReadInputStream getMysqlInput() throws IOException {
        if (this.mysqlInput != null) {
            return this.mysqlInput;
        }
        throw new IOException(Messages.getString("SocketConnection.2"));
    }

    @Override
    public void setMysqlInput(FullReadInputStream mysqlInput) {
        this.mysqlInput = mysqlInput;
    }

    @Override
    public BufferedOutputStream getMysqlOutput() throws IOException {
        if (this.mysqlOutput != null) {
            return this.mysqlOutput;
        }
        throw new IOException(Messages.getString("SocketConnection.2"));
    }

    @Override
    public boolean isSSLEstablished() {
        return ExportControlled.enabled() && ExportControlled.isSSLEstablished(this.getMysqlSocket());
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @Override
    public void forceClose() {
        try {
            this.getNetworkResources().forceClose();
        }
        finally {
            this.mysqlSocket = null;
            this.mysqlInput = null;
            this.mysqlOutput = null;
        }
    }

    @Override
    public NetworkResources getNetworkResources() {
        return new NetworkResources(this.mysqlSocket, this.mysqlInput, this.mysqlOutput);
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    @Override
    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    protected SocketFactory createSocketFactory(String socketFactoryClassName) {
        try {
            if (socketFactoryClassName == null) {
                throw ExceptionFactory.createException(UnableToConnectException.class, Messages.getString("SocketConnection.0"), this.getExceptionInterceptor());
            }
            Object sf = Class.forName(socketFactoryClassName).newInstance();
            if (sf instanceof SocketFactory) {
                return (SocketFactory)Class.forName(socketFactoryClassName).newInstance();
            }
            return new SocketFactoryWrapper(sf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | CJException ex) {
            throw ExceptionFactory.createException(UnableToConnectException.class, Messages.getString("SocketConnection.1", new String[]{socketFactoryClassName}), this.getExceptionInterceptor());
        }
    }
}

