/*
 * Decompiled with CFR 0.152.
 */
package plan.com.mysql.cj.protocol.x;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import plan.com.google.protobuf.GeneratedMessageV3;
import plan.com.mysql.cj.exceptions.WrongArgumentException;
import plan.com.mysql.cj.protocol.MessageListener;
import plan.com.mysql.cj.protocol.ProtocolEntity;
import plan.com.mysql.cj.protocol.ProtocolEntityFactory;
import plan.com.mysql.cj.protocol.ResultBuilder;
import plan.com.mysql.cj.protocol.x.XMessage;
import plan.com.mysql.cj.protocol.x.XProtocolError;
import plan.com.mysql.cj.x.protobuf.Mysqlx;

public class ResultMessageListener<R>
implements MessageListener<XMessage> {
    private ResultBuilder<?> resultBuilder;
    private CompletableFuture<R> future;
    private Map<Class<? extends GeneratedMessageV3>, ProtocolEntityFactory<? extends ProtocolEntity, XMessage>> messageToProtocolEntityFactory = new HashMap<Class<? extends GeneratedMessageV3>, ProtocolEntityFactory<? extends ProtocolEntity, XMessage>>();

    public ResultMessageListener(Map<Class<? extends GeneratedMessageV3>, ProtocolEntityFactory<? extends ProtocolEntity, XMessage>> messageToProtocolEntityFactory, ResultBuilder<R> resultBuilder, CompletableFuture<R> future) {
        this.messageToProtocolEntityFactory = messageToProtocolEntityFactory;
        this.resultBuilder = resultBuilder;
        this.future = future;
    }

    @Override
    public boolean processMessage(XMessage message) {
        Class<?> msgClass = message.getMessage().getClass();
        if (Mysqlx.Error.class.equals(msgClass)) {
            this.future.completeExceptionally(new XProtocolError((Mysqlx.Error)Mysqlx.Error.class.cast(message.getMessage())));
        } else if (!this.messageToProtocolEntityFactory.containsKey(msgClass)) {
            this.future.completeExceptionally(new WrongArgumentException("Unhandled msg class (" + msgClass + ") + msg=" + message.getMessage()));
        } else {
            if (!this.resultBuilder.addProtocolEntity(this.messageToProtocolEntityFactory.get(msgClass).createFromMessage(message))) {
                return false;
            }
            this.future.complete(this.resultBuilder.build());
        }
        return true;
    }

    @Override
    public void error(Throwable ex) {
        this.future.completeExceptionally(ex);
    }
}

