/*
 * Decompiled with CFR 0.152.
 */
package plan.com.mysql.cj.result;

import java.time.LocalDate;
import plan.com.mysql.cj.Messages;
import plan.com.mysql.cj.WarningListener;
import plan.com.mysql.cj.conf.PropertySet;
import plan.com.mysql.cj.exceptions.DataReadException;
import plan.com.mysql.cj.protocol.InternalDate;
import plan.com.mysql.cj.protocol.InternalTime;
import plan.com.mysql.cj.protocol.InternalTimestamp;
import plan.com.mysql.cj.result.AbstractDateTimeValueFactory;

public class LocalDateValueFactory
extends AbstractDateTimeValueFactory<LocalDate> {
    private WarningListener warningListener;

    public LocalDateValueFactory(PropertySet pset) {
        super(pset);
    }

    public LocalDateValueFactory(PropertySet pset, WarningListener warningListener) {
        this(pset);
        this.warningListener = warningListener;
    }

    @Override
    public LocalDate localCreateFromDate(InternalDate idate) {
        if (idate.getYear() == 0 && idate.getMonth() == 0 && idate.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        return LocalDate.of(idate.getYear(), idate.getMonth(), idate.getDay());
    }

    @Override
    public LocalDate localCreateFromTimestamp(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{this.getTargetTypeName()}));
        }
        return (LocalDate)this.createFromDate(its);
    }

    @Override
    LocalDate localCreateFromTime(InternalTime it) {
        return (LocalDate)this.unsupported("TIME");
    }

    @Override
    public String getTargetTypeName() {
        return LocalDate.class.getName();
    }
}

