/*
 * Decompiled with CFR 0.152.
 */
package plan.org.apache.http.impl.client;

import java.io.IOException;
import plan.org.apache.http.HttpEntity;
import plan.org.apache.http.HttpResponse;
import plan.org.apache.http.StatusLine;
import plan.org.apache.http.annotation.Contract;
import plan.org.apache.http.annotation.ThreadingBehavior;
import plan.org.apache.http.client.HttpResponseException;
import plan.org.apache.http.client.ResponseHandler;
import plan.org.apache.http.util.EntityUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

