/*
 * Decompiled with CFR 0.152.
 */
package plan.org.apache.http.impl.conn;

import plan.org.apache.http.HttpResponse;
import plan.org.apache.http.HttpResponseFactory;
import plan.org.apache.http.annotation.Contract;
import plan.org.apache.http.annotation.ThreadingBehavior;
import plan.org.apache.http.config.MessageConstraints;
import plan.org.apache.http.impl.DefaultHttpResponseFactory;
import plan.org.apache.http.impl.conn.DefaultHttpResponseParser;
import plan.org.apache.http.io.HttpMessageParser;
import plan.org.apache.http.io.HttpMessageParserFactory;
import plan.org.apache.http.io.SessionInputBuffer;
import plan.org.apache.http.message.BasicLineParser;
import plan.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

