/*
 * Decompiled with CFR 0.152.
 */
package plan.org.apache.http.impl.cookie;

import plan.org.apache.http.annotation.Contract;
import plan.org.apache.http.annotation.ThreadingBehavior;
import plan.org.apache.http.cookie.CommonCookieAttributeHandler;
import plan.org.apache.http.cookie.Cookie;
import plan.org.apache.http.cookie.CookieOrigin;
import plan.org.apache.http.cookie.MalformedCookieException;
import plan.org.apache.http.cookie.SetCookie;
import plan.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import plan.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

