/*
 * Decompiled with CFR 0.152.
 */
package plan.org.apache.http.impl.cookie;

import plan.org.apache.http.annotation.Contract;
import plan.org.apache.http.annotation.ThreadingBehavior;
import plan.org.apache.http.cookie.CommonCookieAttributeHandler;
import plan.org.apache.http.cookie.Cookie;
import plan.org.apache.http.cookie.CookieOrigin;
import plan.org.apache.http.cookie.CookieRestrictionViolationException;
import plan.org.apache.http.cookie.MalformedCookieException;
import plan.org.apache.http.cookie.SetCookie;
import plan.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import plan.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

