/*
 * Decompiled with CFR 0.152.
 */
package plan.org.apache.http.impl.io;

import plan.org.apache.http.HttpRequest;
import plan.org.apache.http.HttpRequestFactory;
import plan.org.apache.http.annotation.Contract;
import plan.org.apache.http.annotation.ThreadingBehavior;
import plan.org.apache.http.config.MessageConstraints;
import plan.org.apache.http.impl.DefaultHttpRequestFactory;
import plan.org.apache.http.impl.io.DefaultHttpRequestParser;
import plan.org.apache.http.io.HttpMessageParser;
import plan.org.apache.http.io.HttpMessageParserFactory;
import plan.org.apache.http.io.SessionInputBuffer;
import plan.org.apache.http.message.BasicLineParser;
import plan.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

