/*
 * Decompiled with CFR 0.152.
 */
package plan.org.apache.http.protocol;

import java.io.IOException;
import plan.org.apache.http.HttpException;
import plan.org.apache.http.HttpRequest;
import plan.org.apache.http.HttpRequestInterceptor;
import plan.org.apache.http.annotation.Contract;
import plan.org.apache.http.annotation.ThreadingBehavior;
import plan.org.apache.http.protocol.HttpContext;
import plan.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

