/*
 * Decompiled with CFR 0.152.
 */
package plan.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import plan.org.apache.http.HttpConnection;
import plan.org.apache.http.HttpException;
import plan.org.apache.http.HttpHost;
import plan.org.apache.http.HttpInetConnection;
import plan.org.apache.http.HttpRequest;
import plan.org.apache.http.HttpRequestInterceptor;
import plan.org.apache.http.HttpVersion;
import plan.org.apache.http.ProtocolException;
import plan.org.apache.http.ProtocolVersion;
import plan.org.apache.http.annotation.Contract;
import plan.org.apache.http.annotation.ThreadingBehavior;
import plan.org.apache.http.protocol.HttpContext;
import plan.org.apache.http.protocol.HttpCoreContext;
import plan.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

